/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.DetachPrincipalPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DetachPrincipalPolicyRequestMarshaller
implements Marshaller<Request<DetachPrincipalPolicyRequest>, DetachPrincipalPolicyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DetachPrincipalPolicyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DetachPrincipalPolicyRequest> marshall(DetachPrincipalPolicyRequest detachPrincipalPolicyRequest) {
        if (detachPrincipalPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DetachPrincipalPolicyRequest> request = new DefaultRequest<DetachPrincipalPolicyRequest>(detachPrincipalPolicyRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (detachPrincipalPolicyRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-iot-principal", StringUtils.fromString(detachPrincipalPolicyRequest.getPrincipal()));
        }
        String uriResourcePath = "/principal-policies/{policyName}";
        uriResourcePath = uriResourcePath.replace("{policyName}", detachPrincipalPolicyRequest.getPolicyName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(detachPrincipalPolicyRequest.getPolicyName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

