/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.inspector.model.FailedItemDetails;
import com.amazonaws.services.inspector.model.Finding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescribeFindingsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Finding> findings;
    private Map<String, FailedItemDetails> failedItems;

    public List<Finding> getFindings() {
        return this.findings;
    }

    public void setFindings(Collection<Finding> findings) {
        if (findings == null) {
            this.findings = null;
            return;
        }
        this.findings = new ArrayList<Finding>(findings);
    }

    public DescribeFindingsResult withFindings(Finding ... findings) {
        if (this.findings == null) {
            this.setFindings(new ArrayList<Finding>(findings.length));
        }
        for (Finding ele : findings) {
            this.findings.add(ele);
        }
        return this;
    }

    public DescribeFindingsResult withFindings(Collection<Finding> findings) {
        this.setFindings(findings);
        return this;
    }

    public Map<String, FailedItemDetails> getFailedItems() {
        return this.failedItems;
    }

    public void setFailedItems(Map<String, FailedItemDetails> failedItems) {
        this.failedItems = failedItems;
    }

    public DescribeFindingsResult withFailedItems(Map<String, FailedItemDetails> failedItems) {
        this.setFailedItems(failedItems);
        return this;
    }

    public DescribeFindingsResult addFailedItemsEntry(String key, FailedItemDetails value) {
        if (null == this.failedItems) {
            this.failedItems = new HashMap<String, FailedItemDetails>();
        }
        if (this.failedItems.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.failedItems.put(key, value);
        return this;
    }

    public DescribeFindingsResult clearFailedItemsEntries() {
        this.failedItems = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFindings() != null) {
            sb.append("Findings: " + this.getFindings() + ",");
        }
        if (this.getFailedItems() != null) {
            sb.append("FailedItems: " + this.getFailedItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFindingsResult)) {
            return false;
        }
        DescribeFindingsResult other = (DescribeFindingsResult)obj;
        if (other.getFindings() == null ^ this.getFindings() == null) {
            return false;
        }
        if (other.getFindings() != null && !other.getFindings().equals(this.getFindings())) {
            return false;
        }
        if (other.getFailedItems() == null ^ this.getFailedItems() == null) {
            return false;
        }
        return other.getFailedItems() == null || other.getFailedItems().equals(this.getFailedItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFindings() == null ? 0 : this.getFindings().hashCode());
        hashCode = 31 * hashCode + (this.getFailedItems() == null ? 0 : this.getFailedItems().hashCode());
        return hashCode;
    }

    public DescribeFindingsResult clone() {
        try {
            return (DescribeFindingsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

