/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidentity.model.LookupDeveloperIdentityRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class LookupDeveloperIdentityRequestMarshaller
implements Marshaller<Request<LookupDeveloperIdentityRequest>, LookupDeveloperIdentityRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public LookupDeveloperIdentityRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<LookupDeveloperIdentityRequest> marshall(LookupDeveloperIdentityRequest lookupDeveloperIdentityRequest) {
        if (lookupDeveloperIdentityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<LookupDeveloperIdentityRequest> request = new DefaultRequest<LookupDeveloperIdentityRequest>(lookupDeveloperIdentityRequest, "AmazonCognitoIdentity");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityService.LookupDeveloperIdentity");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (lookupDeveloperIdentityRequest.getIdentityPoolId() != null) {
                jsonGenerator.writeFieldName("IdentityPoolId").writeValue(lookupDeveloperIdentityRequest.getIdentityPoolId());
            }
            if (lookupDeveloperIdentityRequest.getIdentityId() != null) {
                jsonGenerator.writeFieldName("IdentityId").writeValue(lookupDeveloperIdentityRequest.getIdentityId());
            }
            if (lookupDeveloperIdentityRequest.getDeveloperUserIdentifier() != null) {
                jsonGenerator.writeFieldName("DeveloperUserIdentifier").writeValue(lookupDeveloperIdentityRequest.getDeveloperUserIdentifier());
            }
            if (lookupDeveloperIdentityRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(lookupDeveloperIdentityRequest.getMaxResults());
            }
            if (lookupDeveloperIdentityRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(lookupDeveloperIdentityRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

