/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.PutApprovalResultRequest;
import com.amazonaws.services.codepipeline.model.transform.ApprovalResultJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class PutApprovalResultRequestMarshaller
implements Marshaller<Request<PutApprovalResultRequest>, PutApprovalResultRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutApprovalResultRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PutApprovalResultRequest> marshall(PutApprovalResultRequest putApprovalResultRequest) {
        if (putApprovalResultRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutApprovalResultRequest> request = new DefaultRequest<PutApprovalResultRequest>(putApprovalResultRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.PutApprovalResult");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putApprovalResultRequest.getPipelineName() != null) {
                jsonGenerator.writeFieldName("pipelineName").writeValue(putApprovalResultRequest.getPipelineName());
            }
            if (putApprovalResultRequest.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(putApprovalResultRequest.getStageName());
            }
            if (putApprovalResultRequest.getActionName() != null) {
                jsonGenerator.writeFieldName("actionName").writeValue(putApprovalResultRequest.getActionName());
            }
            if (putApprovalResultRequest.getResult() != null) {
                jsonGenerator.writeFieldName("result");
                ApprovalResultJsonMarshaller.getInstance().marshall(putApprovalResultRequest.getResult(), jsonGenerator);
            }
            if (putApprovalResultRequest.getToken() != null) {
                jsonGenerator.writeFieldName("token").writeValue(putApprovalResultRequest.getToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

