/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.CreateDeploymentRequest;
import com.amazonaws.services.codedeploy.model.transform.AutoRollbackConfigurationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateDeploymentRequestMarshaller
implements Marshaller<Request<CreateDeploymentRequest>, CreateDeploymentRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateDeploymentRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateDeploymentRequest> marshall(CreateDeploymentRequest createDeploymentRequest) {
        if (createDeploymentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDeploymentRequest> request = new DefaultRequest<CreateDeploymentRequest>(createDeploymentRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.CreateDeployment");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDeploymentRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(createDeploymentRequest.getApplicationName());
            }
            if (createDeploymentRequest.getDeploymentGroupName() != null) {
                jsonGenerator.writeFieldName("deploymentGroupName").writeValue(createDeploymentRequest.getDeploymentGroupName());
            }
            if (createDeploymentRequest.getRevision() != null) {
                jsonGenerator.writeFieldName("revision");
                RevisionLocationJsonMarshaller.getInstance().marshall(createDeploymentRequest.getRevision(), jsonGenerator);
            }
            if (createDeploymentRequest.getDeploymentConfigName() != null) {
                jsonGenerator.writeFieldName("deploymentConfigName").writeValue(createDeploymentRequest.getDeploymentConfigName());
            }
            if (createDeploymentRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(createDeploymentRequest.getDescription());
            }
            if (createDeploymentRequest.getIgnoreApplicationStopFailures() != null) {
                jsonGenerator.writeFieldName("ignoreApplicationStopFailures").writeValue(createDeploymentRequest.getIgnoreApplicationStopFailures());
            }
            if (createDeploymentRequest.getAutoRollbackConfiguration() != null) {
                jsonGenerator.writeFieldName("autoRollbackConfiguration");
                AutoRollbackConfigurationJsonMarshaller.getInstance().marshall(createDeploymentRequest.getAutoRollbackConfiguration(), jsonGenerator);
            }
            if (createDeploymentRequest.getUpdateOutdatedInstancesOnly() != null) {
                jsonGenerator.writeFieldName("updateOutdatedInstancesOnly").writeValue(createDeploymentRequest.getUpdateOutdatedInstancesOnly());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

