/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetDomainNameRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetDomainNameRequestMarshaller
implements Marshaller<Request<GetDomainNameRequest>, GetDomainNameRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetDomainNameRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDomainNameRequest> marshall(GetDomainNameRequest getDomainNameRequest) {
        if (getDomainNameRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDomainNameRequest> request = new DefaultRequest<GetDomainNameRequest>(getDomainNameRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/domainnames/{domain_name}";
        uriResourcePath = uriResourcePath.replace("{domain_name}", getDomainNameRequest.getDomainName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getDomainNameRequest.getDomainName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

