/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.DeleteDeploymentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteDeploymentRequestMarshaller
implements Marshaller<Request<DeleteDeploymentRequest>, DeleteDeploymentRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteDeploymentRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteDeploymentRequest> marshall(DeleteDeploymentRequest deleteDeploymentRequest) {
        if (deleteDeploymentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteDeploymentRequest> request = new DefaultRequest<DeleteDeploymentRequest>(deleteDeploymentRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/deployments/{deployment_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteDeploymentRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteDeploymentRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{deployment_id}", deleteDeploymentRequest.getDeploymentId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteDeploymentRequest.getDeploymentId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

