/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.UpdateXssMatchSetRequest;
import com.amazonaws.services.waf.model.XssMatchSetUpdate;
import com.amazonaws.services.waf.model.transform.XssMatchSetUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdateXssMatchSetRequestMarshaller
implements Marshaller<Request<UpdateXssMatchSetRequest>, UpdateXssMatchSetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateXssMatchSetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateXssMatchSetRequest> marshall(UpdateXssMatchSetRequest updateXssMatchSetRequest) {
        if (updateXssMatchSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateXssMatchSetRequest> request = new DefaultRequest<UpdateXssMatchSetRequest>(updateXssMatchSetRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.UpdateXssMatchSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<XssMatchSetUpdate> updatesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateXssMatchSetRequest.getXssMatchSetId() != null) {
                jsonGenerator.writeFieldName("XssMatchSetId").writeValue(updateXssMatchSetRequest.getXssMatchSetId());
            }
            if (updateXssMatchSetRequest.getChangeToken() != null) {
                jsonGenerator.writeFieldName("ChangeToken").writeValue(updateXssMatchSetRequest.getChangeToken());
            }
            if ((updatesList = updateXssMatchSetRequest.getUpdates()) != null) {
                jsonGenerator.writeFieldName("Updates");
                jsonGenerator.writeStartArray();
                for (XssMatchSetUpdate updatesListValue : updatesList) {
                    if (updatesListValue == null) continue;
                    XssMatchSetUpdateJsonMarshaller.getInstance().marshall(updatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

