/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.simpledb.AmazonSimpleDBAsync;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesResult;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchPutAttributesResult;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.CreateDomainResult;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeleteAttributesResult;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DeleteDomainResult;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesResult;
import com.amazonaws.services.simpledb.model.ListDomainsRequest;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.PutAttributesResult;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSimpleDBAsyncClient
extends AmazonSimpleDBClient
implements AmazonSimpleDBAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonSimpleDBAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AmazonSimpleDBAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSimpleDBAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonSimpleDBAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonSimpleDBAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonSimpleDBAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchDeleteAttributesResult> batchDeleteAttributesAsync(BatchDeleteAttributesRequest request) {
        return this.batchDeleteAttributesAsync(request, null);
    }

    @Override
    public Future<BatchDeleteAttributesResult> batchDeleteAttributesAsync(final BatchDeleteAttributesRequest request, final AsyncHandler<BatchDeleteAttributesRequest, BatchDeleteAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchDeleteAttributesResult>(){

            @Override
            public BatchDeleteAttributesResult call() throws Exception {
                BatchDeleteAttributesResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.batchDeleteAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchPutAttributesResult> batchPutAttributesAsync(BatchPutAttributesRequest request) {
        return this.batchPutAttributesAsync(request, null);
    }

    @Override
    public Future<BatchPutAttributesResult> batchPutAttributesAsync(final BatchPutAttributesRequest request, final AsyncHandler<BatchPutAttributesRequest, BatchPutAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchPutAttributesResult>(){

            @Override
            public BatchPutAttributesResult call() throws Exception {
                BatchPutAttributesResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.batchPutAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDomainResult> createDomainAsync(CreateDomainRequest request) {
        return this.createDomainAsync(request, null);
    }

    @Override
    public Future<CreateDomainResult> createDomainAsync(final CreateDomainRequest request, final AsyncHandler<CreateDomainRequest, CreateDomainResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDomainResult>(){

            @Override
            public CreateDomainResult call() throws Exception {
                CreateDomainResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.createDomain(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAttributesResult> deleteAttributesAsync(DeleteAttributesRequest request) {
        return this.deleteAttributesAsync(request, null);
    }

    @Override
    public Future<DeleteAttributesResult> deleteAttributesAsync(final DeleteAttributesRequest request, final AsyncHandler<DeleteAttributesRequest, DeleteAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteAttributesResult>(){

            @Override
            public DeleteAttributesResult call() throws Exception {
                DeleteAttributesResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.deleteAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDomainResult> deleteDomainAsync(DeleteDomainRequest request) {
        return this.deleteDomainAsync(request, null);
    }

    @Override
    public Future<DeleteDomainResult> deleteDomainAsync(final DeleteDomainRequest request, final AsyncHandler<DeleteDomainRequest, DeleteDomainResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDomainResult>(){

            @Override
            public DeleteDomainResult call() throws Exception {
                DeleteDomainResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.deleteDomain(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DomainMetadataResult> domainMetadataAsync(DomainMetadataRequest request) {
        return this.domainMetadataAsync(request, null);
    }

    @Override
    public Future<DomainMetadataResult> domainMetadataAsync(final DomainMetadataRequest request, final AsyncHandler<DomainMetadataRequest, DomainMetadataResult> asyncHandler) {
        return this.executorService.submit(new Callable<DomainMetadataResult>(){

            @Override
            public DomainMetadataResult call() throws Exception {
                DomainMetadataResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.domainMetadata(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAttributesResult> getAttributesAsync(GetAttributesRequest request) {
        return this.getAttributesAsync(request, null);
    }

    @Override
    public Future<GetAttributesResult> getAttributesAsync(final GetAttributesRequest request, final AsyncHandler<GetAttributesRequest, GetAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetAttributesResult>(){

            @Override
            public GetAttributesResult call() throws Exception {
                GetAttributesResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.getAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDomainsResult> listDomainsAsync(ListDomainsRequest request) {
        return this.listDomainsAsync(request, null);
    }

    @Override
    public Future<ListDomainsResult> listDomainsAsync(final ListDomainsRequest request, final AsyncHandler<ListDomainsRequest, ListDomainsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDomainsResult>(){

            @Override
            public ListDomainsResult call() throws Exception {
                ListDomainsResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.listDomains(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDomainsResult> listDomainsAsync() {
        return this.listDomainsAsync(new ListDomainsRequest());
    }

    @Override
    public Future<ListDomainsResult> listDomainsAsync(AsyncHandler<ListDomainsRequest, ListDomainsResult> asyncHandler) {
        return this.listDomainsAsync(new ListDomainsRequest(), asyncHandler);
    }

    @Override
    public Future<PutAttributesResult> putAttributesAsync(PutAttributesRequest request) {
        return this.putAttributesAsync(request, null);
    }

    @Override
    public Future<PutAttributesResult> putAttributesAsync(final PutAttributesRequest request, final AsyncHandler<PutAttributesRequest, PutAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutAttributesResult>(){

            @Override
            public PutAttributesResult call() throws Exception {
                PutAttributesResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.putAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SelectResult> selectAsync(SelectRequest request) {
        return this.selectAsync(request, null);
    }

    @Override
    public Future<SelectResult> selectAsync(final SelectRequest request, final AsyncHandler<SelectRequest, SelectResult> asyncHandler) {
        return this.executorService.submit(new Callable<SelectResult>(){

            @Override
            public SelectResult call() throws Exception {
                SelectResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.select(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

