/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.Event;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeEventsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String marker;
    private SdkInternalList<Event> events;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeEventsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<Event> getEvents() {
        if (this.events == null) {
            this.events = new SdkInternalList();
        }
        return this.events;
    }

    public void setEvents(Collection<Event> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new SdkInternalList<Event>(events);
    }

    public DescribeEventsResult withEvents(Event ... events) {
        if (this.events == null) {
            this.setEvents(new SdkInternalList<Event>(events.length));
        }
        for (Event ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    public DescribeEventsResult withEvents(Collection<Event> events) {
        this.setEvents(events);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsResult)) {
            return false;
        }
        DescribeEventsResult other = (DescribeEventsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public DescribeEventsResult clone() {
        try {
            return (DescribeEventsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

