/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.Stack;
import com.amazonaws.services.opsworks.model.transform.ChefConfigurationJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.StackConfigurationManagerJsonMarshaller;
import java.util.Map;

public class StackJsonMarshaller {
    private static StackJsonMarshaller instance;

    public void marshall(Stack stack, StructuredJsonGenerator jsonGenerator) {
        if (stack == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap attributesMap;
            jsonGenerator.writeStartObject();
            if (stack.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(stack.getStackId());
            }
            if (stack.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(stack.getName());
            }
            if (stack.getArn() != null) {
                jsonGenerator.writeFieldName("Arn").writeValue(stack.getArn());
            }
            if (stack.getRegion() != null) {
                jsonGenerator.writeFieldName("Region").writeValue(stack.getRegion());
            }
            if (stack.getVpcId() != null) {
                jsonGenerator.writeFieldName("VpcId").writeValue(stack.getVpcId());
            }
            if (!(attributesMap = (SdkInternalMap)stack.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)attributesMapValue.getKey());
                    jsonGenerator.writeValue((String)attributesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (stack.getServiceRoleArn() != null) {
                jsonGenerator.writeFieldName("ServiceRoleArn").writeValue(stack.getServiceRoleArn());
            }
            if (stack.getDefaultInstanceProfileArn() != null) {
                jsonGenerator.writeFieldName("DefaultInstanceProfileArn").writeValue(stack.getDefaultInstanceProfileArn());
            }
            if (stack.getDefaultOs() != null) {
                jsonGenerator.writeFieldName("DefaultOs").writeValue(stack.getDefaultOs());
            }
            if (stack.getHostnameTheme() != null) {
                jsonGenerator.writeFieldName("HostnameTheme").writeValue(stack.getHostnameTheme());
            }
            if (stack.getDefaultAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("DefaultAvailabilityZone").writeValue(stack.getDefaultAvailabilityZone());
            }
            if (stack.getDefaultSubnetId() != null) {
                jsonGenerator.writeFieldName("DefaultSubnetId").writeValue(stack.getDefaultSubnetId());
            }
            if (stack.getCustomJson() != null) {
                jsonGenerator.writeFieldName("CustomJson").writeValue(stack.getCustomJson());
            }
            if (stack.getConfigurationManager() != null) {
                jsonGenerator.writeFieldName("ConfigurationManager");
                StackConfigurationManagerJsonMarshaller.getInstance().marshall(stack.getConfigurationManager(), jsonGenerator);
            }
            if (stack.getChefConfiguration() != null) {
                jsonGenerator.writeFieldName("ChefConfiguration");
                ChefConfigurationJsonMarshaller.getInstance().marshall(stack.getChefConfiguration(), jsonGenerator);
            }
            if (stack.getUseCustomCookbooks() != null) {
                jsonGenerator.writeFieldName("UseCustomCookbooks").writeValue(stack.getUseCustomCookbooks());
            }
            if (stack.getUseOpsworksSecurityGroups() != null) {
                jsonGenerator.writeFieldName("UseOpsworksSecurityGroups").writeValue(stack.getUseOpsworksSecurityGroups());
            }
            if (stack.getCustomCookbooksSource() != null) {
                jsonGenerator.writeFieldName("CustomCookbooksSource");
                SourceJsonMarshaller.getInstance().marshall(stack.getCustomCookbooksSource(), jsonGenerator);
            }
            if (stack.getDefaultSshKeyName() != null) {
                jsonGenerator.writeFieldName("DefaultSshKeyName").writeValue(stack.getDefaultSshKeyName());
            }
            if (stack.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(stack.getCreatedAt());
            }
            if (stack.getDefaultRootDeviceType() != null) {
                jsonGenerator.writeFieldName("DefaultRootDeviceType").writeValue(stack.getDefaultRootDeviceType());
            }
            if (stack.getAgentVersion() != null) {
                jsonGenerator.writeFieldName("AgentVersion").writeValue(stack.getAgentVersion());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StackJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StackJsonMarshaller();
        }
        return instance;
    }
}

