/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.ExportTask;
import com.amazonaws.services.logs.model.transform.ExportTaskExecutionInfoJsonMarshaller;
import com.amazonaws.services.logs.model.transform.ExportTaskStatusJsonMarshaller;

public class ExportTaskJsonMarshaller {
    private static ExportTaskJsonMarshaller instance;

    public void marshall(ExportTask exportTask, StructuredJsonGenerator jsonGenerator) {
        if (exportTask == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (exportTask.getTaskId() != null) {
                jsonGenerator.writeFieldName("taskId").writeValue(exportTask.getTaskId());
            }
            if (exportTask.getTaskName() != null) {
                jsonGenerator.writeFieldName("taskName").writeValue(exportTask.getTaskName());
            }
            if (exportTask.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(exportTask.getLogGroupName());
            }
            if (exportTask.getFrom() != null) {
                jsonGenerator.writeFieldName("from").writeValue(exportTask.getFrom());
            }
            if (exportTask.getTo() != null) {
                jsonGenerator.writeFieldName("to").writeValue(exportTask.getTo());
            }
            if (exportTask.getDestination() != null) {
                jsonGenerator.writeFieldName("destination").writeValue(exportTask.getDestination());
            }
            if (exportTask.getDestinationPrefix() != null) {
                jsonGenerator.writeFieldName("destinationPrefix").writeValue(exportTask.getDestinationPrefix());
            }
            if (exportTask.getStatus() != null) {
                jsonGenerator.writeFieldName("status");
                ExportTaskStatusJsonMarshaller.getInstance().marshall(exportTask.getStatus(), jsonGenerator);
            }
            if (exportTask.getExecutionInfo() != null) {
                jsonGenerator.writeFieldName("executionInfo");
                ExportTaskExecutionInfoJsonMarshaller.getInstance().marshall(exportTask.getExecutionInfo(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ExportTaskJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ExportTaskJsonMarshaller();
        }
        return instance;
    }
}

