/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class UpdateFunctionCodeRequestMarshaller
implements Marshaller<Request<UpdateFunctionCodeRequest>, UpdateFunctionCodeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateFunctionCodeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateFunctionCodeRequest> marshall(UpdateFunctionCodeRequest updateFunctionCodeRequest) {
        if (updateFunctionCodeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateFunctionCodeRequest> request = new DefaultRequest<UpdateFunctionCodeRequest>(updateFunctionCodeRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/code";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", updateFunctionCodeRequest.getFunctionName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(updateFunctionCodeRequest.getFunctionName()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateFunctionCodeRequest.getZipFile() != null) {
                jsonGenerator.writeFieldName("ZipFile").writeValue(updateFunctionCodeRequest.getZipFile());
            }
            if (updateFunctionCodeRequest.getS3Bucket() != null) {
                jsonGenerator.writeFieldName("S3Bucket").writeValue(updateFunctionCodeRequest.getS3Bucket());
            }
            if (updateFunctionCodeRequest.getS3Key() != null) {
                jsonGenerator.writeFieldName("S3Key").writeValue(updateFunctionCodeRequest.getS3Key());
            }
            if (updateFunctionCodeRequest.getS3ObjectVersion() != null) {
                jsonGenerator.writeFieldName("S3ObjectVersion").writeValue(updateFunctionCodeRequest.getS3ObjectVersion());
            }
            if (updateFunctionCodeRequest.getPublish() != null) {
                jsonGenerator.writeFieldName("Publish").writeValue(updateFunctionCodeRequest.getPublish());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

