/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.EnhancedMetrics;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.StreamDescription;
import com.amazonaws.services.kinesis.model.transform.EnhancedMetricsJsonMarshaller;
import com.amazonaws.services.kinesis.model.transform.ShardJsonMarshaller;

public class StreamDescriptionJsonMarshaller {
    private static StreamDescriptionJsonMarshaller instance;

    public void marshall(StreamDescription streamDescription, StructuredJsonGenerator jsonGenerator) {
        if (streamDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList enhancedMonitoringList;
            SdkInternalList shardsList;
            jsonGenerator.writeStartObject();
            if (streamDescription.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(streamDescription.getStreamName());
            }
            if (streamDescription.getStreamARN() != null) {
                jsonGenerator.writeFieldName("StreamARN").writeValue(streamDescription.getStreamARN());
            }
            if (streamDescription.getStreamStatus() != null) {
                jsonGenerator.writeFieldName("StreamStatus").writeValue(streamDescription.getStreamStatus());
            }
            if (!(shardsList = (SdkInternalList)streamDescription.getShards()).isEmpty() || !shardsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Shards");
                jsonGenerator.writeStartArray();
                for (Shard shardsListValue : shardsList) {
                    if (shardsListValue == null) continue;
                    ShardJsonMarshaller.getInstance().marshall(shardsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (streamDescription.getHasMoreShards() != null) {
                jsonGenerator.writeFieldName("HasMoreShards").writeValue(streamDescription.getHasMoreShards());
            }
            if (streamDescription.getRetentionPeriodHours() != null) {
                jsonGenerator.writeFieldName("RetentionPeriodHours").writeValue(streamDescription.getRetentionPeriodHours());
            }
            if (!(enhancedMonitoringList = (SdkInternalList)streamDescription.getEnhancedMonitoring()).isEmpty() || !enhancedMonitoringList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EnhancedMonitoring");
                jsonGenerator.writeStartArray();
                for (EnhancedMetrics enhancedMonitoringListValue : enhancedMonitoringList) {
                    if (enhancedMonitoringListValue == null) continue;
                    EnhancedMetricsJsonMarshaller.getInstance().marshall(enhancedMonitoringListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamDescriptionJsonMarshaller();
        }
        return instance;
    }
}

