/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.SubscribeToEventRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class SubscribeToEventRequestMarshaller
implements Marshaller<Request<SubscribeToEventRequest>, SubscribeToEventRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SubscribeToEventRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SubscribeToEventRequest> marshall(SubscribeToEventRequest subscribeToEventRequest) {
        if (subscribeToEventRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SubscribeToEventRequest> request = new DefaultRequest<SubscribeToEventRequest>(subscribeToEventRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.SubscribeToEvent");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (subscribeToEventRequest.getResourceArn() != null) {
                jsonGenerator.writeFieldName("resourceArn").writeValue(subscribeToEventRequest.getResourceArn());
            }
            if (subscribeToEventRequest.getEvent() != null) {
                jsonGenerator.writeFieldName("event").writeValue(subscribeToEventRequest.getEvent());
            }
            if (subscribeToEventRequest.getTopicArn() != null) {
                jsonGenerator.writeFieldName("topicArn").writeValue(subscribeToEventRequest.getTopicArn());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

