/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.DescribeAssessmentTemplatesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DescribeAssessmentTemplatesRequestMarshaller
implements Marshaller<Request<DescribeAssessmentTemplatesRequest>, DescribeAssessmentTemplatesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeAssessmentTemplatesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeAssessmentTemplatesRequest> marshall(DescribeAssessmentTemplatesRequest describeAssessmentTemplatesRequest) {
        if (describeAssessmentTemplatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAssessmentTemplatesRequest> request = new DefaultRequest<DescribeAssessmentTemplatesRequest>(describeAssessmentTemplatesRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.DescribeAssessmentTemplates");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> assessmentTemplateArnsList = describeAssessmentTemplatesRequest.getAssessmentTemplateArns();
            if (assessmentTemplateArnsList != null) {
                jsonGenerator.writeFieldName("assessmentTemplateArns");
                jsonGenerator.writeStartArray();
                for (String assessmentTemplateArnsListValue : assessmentTemplateArnsList) {
                    if (assessmentTemplateArnsListValue == null) continue;
                    jsonGenerator.writeValue(assessmentTemplateArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

