/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest;
import com.amazonaws.services.glacier.model.VaultAccessPolicy;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class SetVaultAccessPolicyRequestMarshaller
implements Marshaller<Request<SetVaultAccessPolicyRequest>, SetVaultAccessPolicyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SetVaultAccessPolicyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SetVaultAccessPolicyRequest> marshall(SetVaultAccessPolicyRequest setVaultAccessPolicyRequest) {
        if (setVaultAccessPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetVaultAccessPolicyRequest> request = new DefaultRequest<SetVaultAccessPolicyRequest>(setVaultAccessPolicyRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/access-policy";
        uriResourcePath = uriResourcePath.replace("{accountId}", setVaultAccessPolicyRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(setVaultAccessPolicyRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", setVaultAccessPolicyRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(setVaultAccessPolicyRequest.getVaultName()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            VaultAccessPolicy policy = setVaultAccessPolicyRequest.getPolicy();
            if (policy != null) {
                jsonGenerator.writeStartObject();
                if (policy.getPolicy() != null) {
                    jsonGenerator.writeFieldName("Policy").writeValue(policy.getPolicy());
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

