/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.DeleteTagsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DeleteTagsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DeleteTagsRequest> {
    private SdkInternalList<String> resources;
    private SdkInternalList<Tag> tags;

    public DeleteTagsRequest() {
    }

    public DeleteTagsRequest(List<String> resources) {
        this.setResources(resources);
    }

    public List<String> getResources() {
        if (this.resources == null) {
            this.resources = new SdkInternalList();
        }
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new SdkInternalList<String>(resources);
    }

    public DeleteTagsRequest withResources(String ... resources) {
        if (this.resources == null) {
            this.setResources(new SdkInternalList<String>(resources.length));
        }
        for (String ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public DeleteTagsRequest withResources(Collection<String> resources) {
        this.setResources(resources);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public DeleteTagsRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public DeleteTagsRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    @Override
    public Request<DeleteTagsRequest> getDryRunRequest() {
        Request<DeleteTagsRequest> request = new DeleteTagsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResources() != null) {
            sb.append("Resources: " + this.getResources() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsRequest)) {
            return false;
        }
        DeleteTagsRequest other = (DeleteTagsRequest)obj;
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public DeleteTagsRequest clone() {
        return (DeleteTagsRequest)super.clone();
    }
}

