/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AdminDeleteUserRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AdminDeleteUserRequestMarshaller
implements Marshaller<Request<AdminDeleteUserRequest>, AdminDeleteUserRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AdminDeleteUserRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AdminDeleteUserRequest> marshall(AdminDeleteUserRequest adminDeleteUserRequest) {
        if (adminDeleteUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AdminDeleteUserRequest> request = new DefaultRequest<AdminDeleteUserRequest>(adminDeleteUserRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.AdminDeleteUser");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (adminDeleteUserRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(adminDeleteUserRequest.getUserPoolId());
            }
            if (adminDeleteUserRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(adminDeleteUserRequest.getUsername());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

