/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.BatchDeleteImageRequest;
import com.amazonaws.services.ecr.model.ImageIdentifier;
import com.amazonaws.services.ecr.model.transform.ImageIdentifierJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class BatchDeleteImageRequestMarshaller
implements Marshaller<Request<BatchDeleteImageRequest>, BatchDeleteImageRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public BatchDeleteImageRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<BatchDeleteImageRequest> marshall(BatchDeleteImageRequest batchDeleteImageRequest) {
        if (batchDeleteImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchDeleteImageRequest> request = new DefaultRequest<BatchDeleteImageRequest>(batchDeleteImageRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.BatchDeleteImage");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<ImageIdentifier> imageIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (batchDeleteImageRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(batchDeleteImageRequest.getRegistryId());
            }
            if (batchDeleteImageRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(batchDeleteImageRequest.getRepositoryName());
            }
            if ((imageIdsList = batchDeleteImageRequest.getImageIds()) != null) {
                jsonGenerator.writeFieldName("imageIds");
                jsonGenerator.writeStartArray();
                for (ImageIdentifier imageIdsListValue : imageIdsList) {
                    if (imageIdsListValue == null) continue;
                    ImageIdentifierJsonMarshaller.getInstance().marshall(imageIdsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

