/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.SchemaAttributeType;
import com.amazonaws.services.cognitoidp.model.transform.NumberAttributeConstraintsTypeJsonMarshaller;
import com.amazonaws.services.cognitoidp.model.transform.StringAttributeConstraintsTypeJsonMarshaller;

public class SchemaAttributeTypeJsonMarshaller {
    private static SchemaAttributeTypeJsonMarshaller instance;

    public void marshall(SchemaAttributeType schemaAttributeType, StructuredJsonGenerator jsonGenerator) {
        if (schemaAttributeType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (schemaAttributeType.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(schemaAttributeType.getName());
            }
            if (schemaAttributeType.getAttributeDataType() != null) {
                jsonGenerator.writeFieldName("AttributeDataType").writeValue(schemaAttributeType.getAttributeDataType());
            }
            if (schemaAttributeType.getDeveloperOnlyAttribute() != null) {
                jsonGenerator.writeFieldName("DeveloperOnlyAttribute").writeValue(schemaAttributeType.getDeveloperOnlyAttribute());
            }
            if (schemaAttributeType.getMutable() != null) {
                jsonGenerator.writeFieldName("Mutable").writeValue(schemaAttributeType.getMutable());
            }
            if (schemaAttributeType.getRequired() != null) {
                jsonGenerator.writeFieldName("Required").writeValue(schemaAttributeType.getRequired());
            }
            if (schemaAttributeType.getNumberAttributeConstraints() != null) {
                jsonGenerator.writeFieldName("NumberAttributeConstraints");
                NumberAttributeConstraintsTypeJsonMarshaller.getInstance().marshall(schemaAttributeType.getNumberAttributeConstraints(), jsonGenerator);
            }
            if (schemaAttributeType.getStringAttributeConstraints() != null) {
                jsonGenerator.writeFieldName("StringAttributeConstraints");
                StringAttributeConstraintsTypeJsonMarshaller.getInstance().marshall(schemaAttributeType.getStringAttributeConstraints(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SchemaAttributeTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SchemaAttributeTypeJsonMarshaller();
        }
        return instance;
    }
}

