/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.BatchGetDeploymentGroupsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class BatchGetDeploymentGroupsRequestMarshaller
implements Marshaller<Request<BatchGetDeploymentGroupsRequest>, BatchGetDeploymentGroupsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public BatchGetDeploymentGroupsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<BatchGetDeploymentGroupsRequest> marshall(BatchGetDeploymentGroupsRequest batchGetDeploymentGroupsRequest) {
        if (batchGetDeploymentGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetDeploymentGroupsRequest> request = new DefaultRequest<BatchGetDeploymentGroupsRequest>(batchGetDeploymentGroupsRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.BatchGetDeploymentGroups");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList deploymentGroupNamesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (batchGetDeploymentGroupsRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(batchGetDeploymentGroupsRequest.getApplicationName());
            }
            if (!(deploymentGroupNamesList = (SdkInternalList)batchGetDeploymentGroupsRequest.getDeploymentGroupNames()).isEmpty() || !deploymentGroupNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("deploymentGroupNames");
                jsonGenerator.writeStartArray();
                for (String deploymentGroupNamesListValue : deploymentGroupNamesList) {
                    if (deploymentGroupNamesListValue == null) continue;
                    jsonGenerator.writeValue(deploymentGroupNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

