/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetUsageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetUsageRequestMarshaller
implements Marshaller<Request<GetUsageRequest>, GetUsageRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetUsageRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetUsageRequest> marshall(GetUsageRequest getUsageRequest) {
        if (getUsageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetUsageRequest> request = new DefaultRequest<GetUsageRequest>(getUsageRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/usageplans/{usageplanId}/usage";
        uriResourcePath = uriResourcePath.replace("{usageplanId}", getUsageRequest.getUsagePlanId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getUsageRequest.getUsagePlanId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (getUsageRequest.getKeyId() != null) {
            request.addParameter("keyId", StringUtils.fromString(getUsageRequest.getKeyId()));
        }
        if (getUsageRequest.getStartDate() != null) {
            request.addParameter("startDate", StringUtils.fromString(getUsageRequest.getStartDate()));
        }
        if (getUsageRequest.getEndDate() != null) {
            request.addParameter("endDate", StringUtils.fromString(getUsageRequest.getEndDate()));
        }
        if (getUsageRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getUsageRequest.getPosition()));
        }
        if (getUsageRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getUsageRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

