/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.support.model.DescribeCasesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeCasesRequestMarshaller
implements Marshaller<Request<DescribeCasesRequest>, DescribeCasesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeCasesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeCasesRequest> marshall(DescribeCasesRequest describeCasesRequest) {
        if (describeCasesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeCasesRequest> request = new DefaultRequest<DescribeCasesRequest>(describeCasesRequest, "AWSSupport");
        request.addHeader("X-Amz-Target", "AWSSupport_20130415.DescribeCases");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList caseIdListList = (SdkInternalList)describeCasesRequest.getCaseIdList();
            if (!caseIdListList.isEmpty() || !caseIdListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("caseIdList");
                jsonGenerator.writeStartArray();
                for (String caseIdListListValue : caseIdListList) {
                    if (caseIdListListValue == null) continue;
                    jsonGenerator.writeValue(caseIdListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeCasesRequest.getDisplayId() != null) {
                jsonGenerator.writeFieldName("displayId").writeValue(describeCasesRequest.getDisplayId());
            }
            if (describeCasesRequest.getAfterTime() != null) {
                jsonGenerator.writeFieldName("afterTime").writeValue(describeCasesRequest.getAfterTime());
            }
            if (describeCasesRequest.getBeforeTime() != null) {
                jsonGenerator.writeFieldName("beforeTime").writeValue(describeCasesRequest.getBeforeTime());
            }
            if (describeCasesRequest.getIncludeResolvedCases() != null) {
                jsonGenerator.writeFieldName("includeResolvedCases").writeValue(describeCasesRequest.getIncludeResolvedCases());
            }
            if (describeCasesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeCasesRequest.getNextToken());
            }
            if (describeCasesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(describeCasesRequest.getMaxResults());
            }
            if (describeCasesRequest.getLanguage() != null) {
                jsonGenerator.writeFieldName("language").writeValue(describeCasesRequest.getLanguage());
            }
            if (describeCasesRequest.getIncludeCommunications() != null) {
                jsonGenerator.writeFieldName("includeCommunications").writeValue(describeCasesRequest.getIncludeCommunications());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

