/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.AutoScalingThresholds;

public class AutoScalingThresholdsJsonMarshaller {
    private static AutoScalingThresholdsJsonMarshaller instance;

    public void marshall(AutoScalingThresholds autoScalingThresholds, StructuredJsonGenerator jsonGenerator) {
        if (autoScalingThresholds == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList alarmsList;
            jsonGenerator.writeStartObject();
            if (autoScalingThresholds.getInstanceCount() != null) {
                jsonGenerator.writeFieldName("InstanceCount").writeValue(autoScalingThresholds.getInstanceCount());
            }
            if (autoScalingThresholds.getThresholdsWaitTime() != null) {
                jsonGenerator.writeFieldName("ThresholdsWaitTime").writeValue(autoScalingThresholds.getThresholdsWaitTime());
            }
            if (autoScalingThresholds.getIgnoreMetricsTime() != null) {
                jsonGenerator.writeFieldName("IgnoreMetricsTime").writeValue(autoScalingThresholds.getIgnoreMetricsTime());
            }
            if (autoScalingThresholds.getCpuThreshold() != null) {
                jsonGenerator.writeFieldName("CpuThreshold").writeValue(autoScalingThresholds.getCpuThreshold());
            }
            if (autoScalingThresholds.getMemoryThreshold() != null) {
                jsonGenerator.writeFieldName("MemoryThreshold").writeValue(autoScalingThresholds.getMemoryThreshold());
            }
            if (autoScalingThresholds.getLoadThreshold() != null) {
                jsonGenerator.writeFieldName("LoadThreshold").writeValue(autoScalingThresholds.getLoadThreshold());
            }
            if (!(alarmsList = (SdkInternalList)autoScalingThresholds.getAlarms()).isEmpty() || !alarmsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Alarms");
                jsonGenerator.writeStartArray();
                for (String alarmsListValue : alarmsList) {
                    if (alarmsListValue == null) continue;
                    jsonGenerator.writeValue(alarmsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AutoScalingThresholdsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AutoScalingThresholdsJsonMarshaller();
        }
        return instance;
    }
}

