/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.InitiateVaultLockRequest;
import com.amazonaws.services.glacier.model.VaultLockPolicy;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class InitiateVaultLockRequestMarshaller
implements Marshaller<Request<InitiateVaultLockRequest>, InitiateVaultLockRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public InitiateVaultLockRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<InitiateVaultLockRequest> marshall(InitiateVaultLockRequest initiateVaultLockRequest) {
        if (initiateVaultLockRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<InitiateVaultLockRequest> request = new DefaultRequest<InitiateVaultLockRequest>(initiateVaultLockRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/lock-policy";
        uriResourcePath = uriResourcePath.replace("{accountId}", initiateVaultLockRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(initiateVaultLockRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", initiateVaultLockRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(initiateVaultLockRequest.getVaultName()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            VaultLockPolicy policy = initiateVaultLockRequest.getPolicy();
            if (policy != null) {
                jsonGenerator.writeStartObject();
                if (policy.getPolicy() != null) {
                    jsonGenerator.writeFieldName("Policy").writeValue(policy.getPolicy());
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

