/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DeleteTagsRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteTagsRequestMarshaller
implements Marshaller<Request<DeleteTagsRequest>, DeleteTagsRequest> {
    @Override
    public Request<DeleteTagsRequest> marshall(DeleteTagsRequest deleteTagsRequest) {
        SdkInternalList deleteTagsRequestTagsList;
        if (deleteTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteTagsRequest> request = new DefaultRequest<DeleteTagsRequest>(deleteTagsRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteTags");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList deleteTagsRequestResourcesList = (SdkInternalList)deleteTagsRequest.getResources();
        if (!deleteTagsRequestResourcesList.isEmpty() || !deleteTagsRequestResourcesList.isAutoConstruct()) {
            int resourcesListIndex = 1;
            for (String deleteTagsRequestResourcesListValue : deleteTagsRequestResourcesList) {
                if (deleteTagsRequestResourcesListValue != null) {
                    request.addParameter("ResourceId." + resourcesListIndex, StringUtils.fromString(deleteTagsRequestResourcesListValue));
                }
                ++resourcesListIndex;
            }
        }
        if (!(deleteTagsRequestTagsList = (SdkInternalList)deleteTagsRequest.getTags()).isEmpty() || !deleteTagsRequestTagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag deleteTagsRequestTagsListValue : deleteTagsRequestTagsList) {
                if (deleteTagsRequestTagsListValue.getKey() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Key", StringUtils.fromString(deleteTagsRequestTagsListValue.getKey()));
                }
                if (deleteTagsRequestTagsListValue.getValue() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Value", StringUtils.fromString(deleteTagsRequestTagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

