/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.GetUserAttributeVerificationCodeRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetUserAttributeVerificationCodeRequestMarshaller
implements Marshaller<Request<GetUserAttributeVerificationCodeRequest>, GetUserAttributeVerificationCodeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetUserAttributeVerificationCodeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetUserAttributeVerificationCodeRequest> marshall(GetUserAttributeVerificationCodeRequest getUserAttributeVerificationCodeRequest) {
        if (getUserAttributeVerificationCodeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetUserAttributeVerificationCodeRequest> request = new DefaultRequest<GetUserAttributeVerificationCodeRequest>(getUserAttributeVerificationCodeRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.GetUserAttributeVerificationCode");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getUserAttributeVerificationCodeRequest.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(getUserAttributeVerificationCodeRequest.getAccessToken());
            }
            if (getUserAttributeVerificationCodeRequest.getAttributeName() != null) {
                jsonGenerator.writeFieldName("AttributeName").writeValue(getUserAttributeVerificationCodeRequest.getAttributeName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

