/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.DeleteMethodRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteMethodRequestMarshaller
implements Marshaller<Request<DeleteMethodRequest>, DeleteMethodRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteMethodRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteMethodRequest> marshall(DeleteMethodRequest deleteMethodRequest) {
        if (deleteMethodRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteMethodRequest> request = new DefaultRequest<DeleteMethodRequest>(deleteMethodRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteMethodRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteMethodRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", deleteMethodRequest.getResourceId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteMethodRequest.getResourceId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", deleteMethodRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteMethodRequest.getHttpMethod()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

