/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.HTTPHeader;
import com.amazonaws.services.waf.model.HTTPRequest;
import com.amazonaws.services.waf.model.transform.HTTPHeaderJsonMarshaller;
import java.util.List;

public class HTTPRequestJsonMarshaller {
    private static HTTPRequestJsonMarshaller instance;

    public void marshall(HTTPRequest hTTPRequest, StructuredJsonGenerator jsonGenerator) {
        if (hTTPRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<HTTPHeader> headersList;
            jsonGenerator.writeStartObject();
            if (hTTPRequest.getClientIP() != null) {
                jsonGenerator.writeFieldName("ClientIP").writeValue(hTTPRequest.getClientIP());
            }
            if (hTTPRequest.getCountry() != null) {
                jsonGenerator.writeFieldName("Country").writeValue(hTTPRequest.getCountry());
            }
            if (hTTPRequest.getURI() != null) {
                jsonGenerator.writeFieldName("URI").writeValue(hTTPRequest.getURI());
            }
            if (hTTPRequest.getMethod() != null) {
                jsonGenerator.writeFieldName("Method").writeValue(hTTPRequest.getMethod());
            }
            if (hTTPRequest.getHTTPVersion() != null) {
                jsonGenerator.writeFieldName("HTTPVersion").writeValue(hTTPRequest.getHTTPVersion());
            }
            if ((headersList = hTTPRequest.getHeaders()) != null) {
                jsonGenerator.writeFieldName("Headers");
                jsonGenerator.writeStartArray();
                for (HTTPHeader headersListValue : headersList) {
                    if (headersListValue == null) continue;
                    HTTPHeaderJsonMarshaller.getInstance().marshall(headersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static HTTPRequestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new HTTPRequestJsonMarshaller();
        }
        return instance;
    }
}

