/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeReservedInstancesModificationsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesModificationsRequest>, DescribeReservedInstancesModificationsRequest> {
    @Override
    public Request<DescribeReservedInstancesModificationsRequest> marshall(DescribeReservedInstancesModificationsRequest describeReservedInstancesModificationsRequest) {
        SdkInternalList filtersList;
        if (describeReservedInstancesModificationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeReservedInstancesModificationsRequest> request = new DefaultRequest<DescribeReservedInstancesModificationsRequest>(describeReservedInstancesModificationsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeReservedInstancesModifications");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList reservedInstancesModificationIdsList = (SdkInternalList)describeReservedInstancesModificationsRequest.getReservedInstancesModificationIds();
        if (!reservedInstancesModificationIdsList.isEmpty() || !reservedInstancesModificationIdsList.isAutoConstruct()) {
            int reservedInstancesModificationIdsListIndex = 1;
            for (String reservedInstancesModificationIdsListValue : reservedInstancesModificationIdsList) {
                if (reservedInstancesModificationIdsListValue != null) {
                    request.addParameter("ReservedInstancesModificationId." + reservedInstancesModificationIdsListIndex, StringUtils.fromString(reservedInstancesModificationIdsListValue));
                }
                ++reservedInstancesModificationIdsListIndex;
            }
        }
        if (describeReservedInstancesModificationsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeReservedInstancesModificationsRequest.getNextToken()));
        }
        if (!(filtersList = (SdkInternalList)describeReservedInstancesModificationsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

