/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.StartUserImportJobRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class StartUserImportJobRequestMarshaller
implements Marshaller<Request<StartUserImportJobRequest>, StartUserImportJobRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public StartUserImportJobRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<StartUserImportJobRequest> marshall(StartUserImportJobRequest startUserImportJobRequest) {
        if (startUserImportJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StartUserImportJobRequest> request = new DefaultRequest<StartUserImportJobRequest>(startUserImportJobRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.StartUserImportJob");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (startUserImportJobRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(startUserImportJobRequest.getUserPoolId());
            }
            if (startUserImportJobRequest.getJobId() != null) {
                jsonGenerator.writeFieldName("JobId").writeValue(startUserImportJobRequest.getJobId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

