/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProviderAsync;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProviderClient;
import com.amazonaws.services.cognitoidp.model.AddCustomAttributesRequest;
import com.amazonaws.services.cognitoidp.model.AddCustomAttributesResult;
import com.amazonaws.services.cognitoidp.model.AdminConfirmSignUpRequest;
import com.amazonaws.services.cognitoidp.model.AdminConfirmSignUpResult;
import com.amazonaws.services.cognitoidp.model.AdminDeleteUserAttributesRequest;
import com.amazonaws.services.cognitoidp.model.AdminDeleteUserAttributesResult;
import com.amazonaws.services.cognitoidp.model.AdminDeleteUserRequest;
import com.amazonaws.services.cognitoidp.model.AdminDeleteUserResult;
import com.amazonaws.services.cognitoidp.model.AdminDisableUserRequest;
import com.amazonaws.services.cognitoidp.model.AdminDisableUserResult;
import com.amazonaws.services.cognitoidp.model.AdminEnableUserRequest;
import com.amazonaws.services.cognitoidp.model.AdminEnableUserResult;
import com.amazonaws.services.cognitoidp.model.AdminForgetDeviceRequest;
import com.amazonaws.services.cognitoidp.model.AdminForgetDeviceResult;
import com.amazonaws.services.cognitoidp.model.AdminGetDeviceRequest;
import com.amazonaws.services.cognitoidp.model.AdminGetDeviceResult;
import com.amazonaws.services.cognitoidp.model.AdminGetUserRequest;
import com.amazonaws.services.cognitoidp.model.AdminGetUserResult;
import com.amazonaws.services.cognitoidp.model.AdminInitiateAuthRequest;
import com.amazonaws.services.cognitoidp.model.AdminInitiateAuthResult;
import com.amazonaws.services.cognitoidp.model.AdminListDevicesRequest;
import com.amazonaws.services.cognitoidp.model.AdminListDevicesResult;
import com.amazonaws.services.cognitoidp.model.AdminResetUserPasswordRequest;
import com.amazonaws.services.cognitoidp.model.AdminResetUserPasswordResult;
import com.amazonaws.services.cognitoidp.model.AdminRespondToAuthChallengeRequest;
import com.amazonaws.services.cognitoidp.model.AdminRespondToAuthChallengeResult;
import com.amazonaws.services.cognitoidp.model.AdminSetUserSettingsRequest;
import com.amazonaws.services.cognitoidp.model.AdminSetUserSettingsResult;
import com.amazonaws.services.cognitoidp.model.AdminUpdateDeviceStatusRequest;
import com.amazonaws.services.cognitoidp.model.AdminUpdateDeviceStatusResult;
import com.amazonaws.services.cognitoidp.model.AdminUpdateUserAttributesRequest;
import com.amazonaws.services.cognitoidp.model.AdminUpdateUserAttributesResult;
import com.amazonaws.services.cognitoidp.model.AdminUserGlobalSignOutRequest;
import com.amazonaws.services.cognitoidp.model.AdminUserGlobalSignOutResult;
import com.amazonaws.services.cognitoidp.model.ChangePasswordRequest;
import com.amazonaws.services.cognitoidp.model.ChangePasswordResult;
import com.amazonaws.services.cognitoidp.model.ConfirmDeviceRequest;
import com.amazonaws.services.cognitoidp.model.ConfirmDeviceResult;
import com.amazonaws.services.cognitoidp.model.ConfirmForgotPasswordRequest;
import com.amazonaws.services.cognitoidp.model.ConfirmForgotPasswordResult;
import com.amazonaws.services.cognitoidp.model.ConfirmSignUpRequest;
import com.amazonaws.services.cognitoidp.model.ConfirmSignUpResult;
import com.amazonaws.services.cognitoidp.model.CreateUserImportJobRequest;
import com.amazonaws.services.cognitoidp.model.CreateUserImportJobResult;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolClientRequest;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolClientResult;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolRequest;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolResult;
import com.amazonaws.services.cognitoidp.model.DeleteUserAttributesRequest;
import com.amazonaws.services.cognitoidp.model.DeleteUserAttributesResult;
import com.amazonaws.services.cognitoidp.model.DeleteUserPoolClientRequest;
import com.amazonaws.services.cognitoidp.model.DeleteUserPoolClientResult;
import com.amazonaws.services.cognitoidp.model.DeleteUserPoolRequest;
import com.amazonaws.services.cognitoidp.model.DeleteUserPoolResult;
import com.amazonaws.services.cognitoidp.model.DeleteUserRequest;
import com.amazonaws.services.cognitoidp.model.DeleteUserResult;
import com.amazonaws.services.cognitoidp.model.DescribeUserImportJobRequest;
import com.amazonaws.services.cognitoidp.model.DescribeUserImportJobResult;
import com.amazonaws.services.cognitoidp.model.DescribeUserPoolClientRequest;
import com.amazonaws.services.cognitoidp.model.DescribeUserPoolClientResult;
import com.amazonaws.services.cognitoidp.model.DescribeUserPoolRequest;
import com.amazonaws.services.cognitoidp.model.DescribeUserPoolResult;
import com.amazonaws.services.cognitoidp.model.ForgetDeviceRequest;
import com.amazonaws.services.cognitoidp.model.ForgetDeviceResult;
import com.amazonaws.services.cognitoidp.model.ForgotPasswordRequest;
import com.amazonaws.services.cognitoidp.model.ForgotPasswordResult;
import com.amazonaws.services.cognitoidp.model.GetCSVHeaderRequest;
import com.amazonaws.services.cognitoidp.model.GetCSVHeaderResult;
import com.amazonaws.services.cognitoidp.model.GetDeviceRequest;
import com.amazonaws.services.cognitoidp.model.GetDeviceResult;
import com.amazonaws.services.cognitoidp.model.GetUserAttributeVerificationCodeRequest;
import com.amazonaws.services.cognitoidp.model.GetUserAttributeVerificationCodeResult;
import com.amazonaws.services.cognitoidp.model.GetUserRequest;
import com.amazonaws.services.cognitoidp.model.GetUserResult;
import com.amazonaws.services.cognitoidp.model.GlobalSignOutRequest;
import com.amazonaws.services.cognitoidp.model.GlobalSignOutResult;
import com.amazonaws.services.cognitoidp.model.InitiateAuthRequest;
import com.amazonaws.services.cognitoidp.model.InitiateAuthResult;
import com.amazonaws.services.cognitoidp.model.ListDevicesRequest;
import com.amazonaws.services.cognitoidp.model.ListDevicesResult;
import com.amazonaws.services.cognitoidp.model.ListUserImportJobsRequest;
import com.amazonaws.services.cognitoidp.model.ListUserImportJobsResult;
import com.amazonaws.services.cognitoidp.model.ListUserPoolClientsRequest;
import com.amazonaws.services.cognitoidp.model.ListUserPoolClientsResult;
import com.amazonaws.services.cognitoidp.model.ListUserPoolsRequest;
import com.amazonaws.services.cognitoidp.model.ListUserPoolsResult;
import com.amazonaws.services.cognitoidp.model.ListUsersRequest;
import com.amazonaws.services.cognitoidp.model.ListUsersResult;
import com.amazonaws.services.cognitoidp.model.ResendConfirmationCodeRequest;
import com.amazonaws.services.cognitoidp.model.ResendConfirmationCodeResult;
import com.amazonaws.services.cognitoidp.model.RespondToAuthChallengeRequest;
import com.amazonaws.services.cognitoidp.model.RespondToAuthChallengeResult;
import com.amazonaws.services.cognitoidp.model.SetUserSettingsRequest;
import com.amazonaws.services.cognitoidp.model.SetUserSettingsResult;
import com.amazonaws.services.cognitoidp.model.SignUpRequest;
import com.amazonaws.services.cognitoidp.model.SignUpResult;
import com.amazonaws.services.cognitoidp.model.StartUserImportJobRequest;
import com.amazonaws.services.cognitoidp.model.StartUserImportJobResult;
import com.amazonaws.services.cognitoidp.model.StopUserImportJobRequest;
import com.amazonaws.services.cognitoidp.model.StopUserImportJobResult;
import com.amazonaws.services.cognitoidp.model.UpdateDeviceStatusRequest;
import com.amazonaws.services.cognitoidp.model.UpdateDeviceStatusResult;
import com.amazonaws.services.cognitoidp.model.UpdateUserAttributesRequest;
import com.amazonaws.services.cognitoidp.model.UpdateUserAttributesResult;
import com.amazonaws.services.cognitoidp.model.UpdateUserPoolClientRequest;
import com.amazonaws.services.cognitoidp.model.UpdateUserPoolClientResult;
import com.amazonaws.services.cognitoidp.model.UpdateUserPoolRequest;
import com.amazonaws.services.cognitoidp.model.UpdateUserPoolResult;
import com.amazonaws.services.cognitoidp.model.VerifyUserAttributeRequest;
import com.amazonaws.services.cognitoidp.model.VerifyUserAttributeResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCognitoIdentityProviderAsyncClient
extends AWSCognitoIdentityProviderClient
implements AWSCognitoIdentityProviderAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCognitoIdentityProviderAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AWSCognitoIdentityProviderAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSCognitoIdentityProviderAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddCustomAttributesResult> addCustomAttributesAsync(AddCustomAttributesRequest request) {
        return this.addCustomAttributesAsync(request, null);
    }

    @Override
    public Future<AddCustomAttributesResult> addCustomAttributesAsync(final AddCustomAttributesRequest request, final AsyncHandler<AddCustomAttributesRequest, AddCustomAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddCustomAttributesResult>(){

            @Override
            public AddCustomAttributesResult call() throws Exception {
                AddCustomAttributesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.addCustomAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminConfirmSignUpResult> adminConfirmSignUpAsync(AdminConfirmSignUpRequest request) {
        return this.adminConfirmSignUpAsync(request, null);
    }

    @Override
    public Future<AdminConfirmSignUpResult> adminConfirmSignUpAsync(final AdminConfirmSignUpRequest request, final AsyncHandler<AdminConfirmSignUpRequest, AdminConfirmSignUpResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminConfirmSignUpResult>(){

            @Override
            public AdminConfirmSignUpResult call() throws Exception {
                AdminConfirmSignUpResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminConfirmSignUp(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminDeleteUserResult> adminDeleteUserAsync(AdminDeleteUserRequest request) {
        return this.adminDeleteUserAsync(request, null);
    }

    @Override
    public Future<AdminDeleteUserResult> adminDeleteUserAsync(final AdminDeleteUserRequest request, final AsyncHandler<AdminDeleteUserRequest, AdminDeleteUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminDeleteUserResult>(){

            @Override
            public AdminDeleteUserResult call() throws Exception {
                AdminDeleteUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminDeleteUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminDeleteUserAttributesResult> adminDeleteUserAttributesAsync(AdminDeleteUserAttributesRequest request) {
        return this.adminDeleteUserAttributesAsync(request, null);
    }

    @Override
    public Future<AdminDeleteUserAttributesResult> adminDeleteUserAttributesAsync(final AdminDeleteUserAttributesRequest request, final AsyncHandler<AdminDeleteUserAttributesRequest, AdminDeleteUserAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminDeleteUserAttributesResult>(){

            @Override
            public AdminDeleteUserAttributesResult call() throws Exception {
                AdminDeleteUserAttributesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminDeleteUserAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminDisableUserResult> adminDisableUserAsync(AdminDisableUserRequest request) {
        return this.adminDisableUserAsync(request, null);
    }

    @Override
    public Future<AdminDisableUserResult> adminDisableUserAsync(final AdminDisableUserRequest request, final AsyncHandler<AdminDisableUserRequest, AdminDisableUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminDisableUserResult>(){

            @Override
            public AdminDisableUserResult call() throws Exception {
                AdminDisableUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminDisableUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminEnableUserResult> adminEnableUserAsync(AdminEnableUserRequest request) {
        return this.adminEnableUserAsync(request, null);
    }

    @Override
    public Future<AdminEnableUserResult> adminEnableUserAsync(final AdminEnableUserRequest request, final AsyncHandler<AdminEnableUserRequest, AdminEnableUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminEnableUserResult>(){

            @Override
            public AdminEnableUserResult call() throws Exception {
                AdminEnableUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminEnableUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminForgetDeviceResult> adminForgetDeviceAsync(AdminForgetDeviceRequest request) {
        return this.adminForgetDeviceAsync(request, null);
    }

    @Override
    public Future<AdminForgetDeviceResult> adminForgetDeviceAsync(final AdminForgetDeviceRequest request, final AsyncHandler<AdminForgetDeviceRequest, AdminForgetDeviceResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminForgetDeviceResult>(){

            @Override
            public AdminForgetDeviceResult call() throws Exception {
                AdminForgetDeviceResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminForgetDevice(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminGetDeviceResult> adminGetDeviceAsync(AdminGetDeviceRequest request) {
        return this.adminGetDeviceAsync(request, null);
    }

    @Override
    public Future<AdminGetDeviceResult> adminGetDeviceAsync(final AdminGetDeviceRequest request, final AsyncHandler<AdminGetDeviceRequest, AdminGetDeviceResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminGetDeviceResult>(){

            @Override
            public AdminGetDeviceResult call() throws Exception {
                AdminGetDeviceResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminGetDevice(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminGetUserResult> adminGetUserAsync(AdminGetUserRequest request) {
        return this.adminGetUserAsync(request, null);
    }

    @Override
    public Future<AdminGetUserResult> adminGetUserAsync(final AdminGetUserRequest request, final AsyncHandler<AdminGetUserRequest, AdminGetUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminGetUserResult>(){

            @Override
            public AdminGetUserResult call() throws Exception {
                AdminGetUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminGetUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminInitiateAuthResult> adminInitiateAuthAsync(AdminInitiateAuthRequest request) {
        return this.adminInitiateAuthAsync(request, null);
    }

    @Override
    public Future<AdminInitiateAuthResult> adminInitiateAuthAsync(final AdminInitiateAuthRequest request, final AsyncHandler<AdminInitiateAuthRequest, AdminInitiateAuthResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminInitiateAuthResult>(){

            @Override
            public AdminInitiateAuthResult call() throws Exception {
                AdminInitiateAuthResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminInitiateAuth(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminListDevicesResult> adminListDevicesAsync(AdminListDevicesRequest request) {
        return this.adminListDevicesAsync(request, null);
    }

    @Override
    public Future<AdminListDevicesResult> adminListDevicesAsync(final AdminListDevicesRequest request, final AsyncHandler<AdminListDevicesRequest, AdminListDevicesResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminListDevicesResult>(){

            @Override
            public AdminListDevicesResult call() throws Exception {
                AdminListDevicesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminListDevices(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminResetUserPasswordResult> adminResetUserPasswordAsync(AdminResetUserPasswordRequest request) {
        return this.adminResetUserPasswordAsync(request, null);
    }

    @Override
    public Future<AdminResetUserPasswordResult> adminResetUserPasswordAsync(final AdminResetUserPasswordRequest request, final AsyncHandler<AdminResetUserPasswordRequest, AdminResetUserPasswordResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminResetUserPasswordResult>(){

            @Override
            public AdminResetUserPasswordResult call() throws Exception {
                AdminResetUserPasswordResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminResetUserPassword(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminRespondToAuthChallengeResult> adminRespondToAuthChallengeAsync(AdminRespondToAuthChallengeRequest request) {
        return this.adminRespondToAuthChallengeAsync(request, null);
    }

    @Override
    public Future<AdminRespondToAuthChallengeResult> adminRespondToAuthChallengeAsync(final AdminRespondToAuthChallengeRequest request, final AsyncHandler<AdminRespondToAuthChallengeRequest, AdminRespondToAuthChallengeResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminRespondToAuthChallengeResult>(){

            @Override
            public AdminRespondToAuthChallengeResult call() throws Exception {
                AdminRespondToAuthChallengeResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminRespondToAuthChallenge(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminSetUserSettingsResult> adminSetUserSettingsAsync(AdminSetUserSettingsRequest request) {
        return this.adminSetUserSettingsAsync(request, null);
    }

    @Override
    public Future<AdminSetUserSettingsResult> adminSetUserSettingsAsync(final AdminSetUserSettingsRequest request, final AsyncHandler<AdminSetUserSettingsRequest, AdminSetUserSettingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminSetUserSettingsResult>(){

            @Override
            public AdminSetUserSettingsResult call() throws Exception {
                AdminSetUserSettingsResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminSetUserSettings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminUpdateDeviceStatusResult> adminUpdateDeviceStatusAsync(AdminUpdateDeviceStatusRequest request) {
        return this.adminUpdateDeviceStatusAsync(request, null);
    }

    @Override
    public Future<AdminUpdateDeviceStatusResult> adminUpdateDeviceStatusAsync(final AdminUpdateDeviceStatusRequest request, final AsyncHandler<AdminUpdateDeviceStatusRequest, AdminUpdateDeviceStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminUpdateDeviceStatusResult>(){

            @Override
            public AdminUpdateDeviceStatusResult call() throws Exception {
                AdminUpdateDeviceStatusResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminUpdateDeviceStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminUpdateUserAttributesResult> adminUpdateUserAttributesAsync(AdminUpdateUserAttributesRequest request) {
        return this.adminUpdateUserAttributesAsync(request, null);
    }

    @Override
    public Future<AdminUpdateUserAttributesResult> adminUpdateUserAttributesAsync(final AdminUpdateUserAttributesRequest request, final AsyncHandler<AdminUpdateUserAttributesRequest, AdminUpdateUserAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminUpdateUserAttributesResult>(){

            @Override
            public AdminUpdateUserAttributesResult call() throws Exception {
                AdminUpdateUserAttributesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminUpdateUserAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminUserGlobalSignOutResult> adminUserGlobalSignOutAsync(AdminUserGlobalSignOutRequest request) {
        return this.adminUserGlobalSignOutAsync(request, null);
    }

    @Override
    public Future<AdminUserGlobalSignOutResult> adminUserGlobalSignOutAsync(final AdminUserGlobalSignOutRequest request, final AsyncHandler<AdminUserGlobalSignOutRequest, AdminUserGlobalSignOutResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminUserGlobalSignOutResult>(){

            @Override
            public AdminUserGlobalSignOutResult call() throws Exception {
                AdminUserGlobalSignOutResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminUserGlobalSignOut(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ChangePasswordResult> changePasswordAsync(ChangePasswordRequest request) {
        return this.changePasswordAsync(request, null);
    }

    @Override
    public Future<ChangePasswordResult> changePasswordAsync(final ChangePasswordRequest request, final AsyncHandler<ChangePasswordRequest, ChangePasswordResult> asyncHandler) {
        return this.executorService.submit(new Callable<ChangePasswordResult>(){

            @Override
            public ChangePasswordResult call() throws Exception {
                ChangePasswordResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.changePassword(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmDeviceResult> confirmDeviceAsync(ConfirmDeviceRequest request) {
        return this.confirmDeviceAsync(request, null);
    }

    @Override
    public Future<ConfirmDeviceResult> confirmDeviceAsync(final ConfirmDeviceRequest request, final AsyncHandler<ConfirmDeviceRequest, ConfirmDeviceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ConfirmDeviceResult>(){

            @Override
            public ConfirmDeviceResult call() throws Exception {
                ConfirmDeviceResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.confirmDevice(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmForgotPasswordResult> confirmForgotPasswordAsync(ConfirmForgotPasswordRequest request) {
        return this.confirmForgotPasswordAsync(request, null);
    }

    @Override
    public Future<ConfirmForgotPasswordResult> confirmForgotPasswordAsync(final ConfirmForgotPasswordRequest request, final AsyncHandler<ConfirmForgotPasswordRequest, ConfirmForgotPasswordResult> asyncHandler) {
        return this.executorService.submit(new Callable<ConfirmForgotPasswordResult>(){

            @Override
            public ConfirmForgotPasswordResult call() throws Exception {
                ConfirmForgotPasswordResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.confirmForgotPassword(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmSignUpResult> confirmSignUpAsync(ConfirmSignUpRequest request) {
        return this.confirmSignUpAsync(request, null);
    }

    @Override
    public Future<ConfirmSignUpResult> confirmSignUpAsync(final ConfirmSignUpRequest request, final AsyncHandler<ConfirmSignUpRequest, ConfirmSignUpResult> asyncHandler) {
        return this.executorService.submit(new Callable<ConfirmSignUpResult>(){

            @Override
            public ConfirmSignUpResult call() throws Exception {
                ConfirmSignUpResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.confirmSignUp(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserImportJobResult> createUserImportJobAsync(CreateUserImportJobRequest request) {
        return this.createUserImportJobAsync(request, null);
    }

    @Override
    public Future<CreateUserImportJobResult> createUserImportJobAsync(final CreateUserImportJobRequest request, final AsyncHandler<CreateUserImportJobRequest, CreateUserImportJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateUserImportJobResult>(){

            @Override
            public CreateUserImportJobResult call() throws Exception {
                CreateUserImportJobResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.createUserImportJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserPoolResult> createUserPoolAsync(CreateUserPoolRequest request) {
        return this.createUserPoolAsync(request, null);
    }

    @Override
    public Future<CreateUserPoolResult> createUserPoolAsync(final CreateUserPoolRequest request, final AsyncHandler<CreateUserPoolRequest, CreateUserPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateUserPoolResult>(){

            @Override
            public CreateUserPoolResult call() throws Exception {
                CreateUserPoolResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.createUserPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserPoolClientResult> createUserPoolClientAsync(CreateUserPoolClientRequest request) {
        return this.createUserPoolClientAsync(request, null);
    }

    @Override
    public Future<CreateUserPoolClientResult> createUserPoolClientAsync(final CreateUserPoolClientRequest request, final AsyncHandler<CreateUserPoolClientRequest, CreateUserPoolClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateUserPoolClientResult>(){

            @Override
            public CreateUserPoolClientResult call() throws Exception {
                CreateUserPoolClientResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.createUserPoolClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request) {
        return this.deleteUserAsync(request, null);
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(final DeleteUserRequest request, final AsyncHandler<DeleteUserRequest, DeleteUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteUserResult>(){

            @Override
            public DeleteUserResult call() throws Exception {
                DeleteUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.deleteUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserAttributesResult> deleteUserAttributesAsync(DeleteUserAttributesRequest request) {
        return this.deleteUserAttributesAsync(request, null);
    }

    @Override
    public Future<DeleteUserAttributesResult> deleteUserAttributesAsync(final DeleteUserAttributesRequest request, final AsyncHandler<DeleteUserAttributesRequest, DeleteUserAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteUserAttributesResult>(){

            @Override
            public DeleteUserAttributesResult call() throws Exception {
                DeleteUserAttributesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.deleteUserAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserPoolResult> deleteUserPoolAsync(DeleteUserPoolRequest request) {
        return this.deleteUserPoolAsync(request, null);
    }

    @Override
    public Future<DeleteUserPoolResult> deleteUserPoolAsync(final DeleteUserPoolRequest request, final AsyncHandler<DeleteUserPoolRequest, DeleteUserPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteUserPoolResult>(){

            @Override
            public DeleteUserPoolResult call() throws Exception {
                DeleteUserPoolResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.deleteUserPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserPoolClientResult> deleteUserPoolClientAsync(DeleteUserPoolClientRequest request) {
        return this.deleteUserPoolClientAsync(request, null);
    }

    @Override
    public Future<DeleteUserPoolClientResult> deleteUserPoolClientAsync(final DeleteUserPoolClientRequest request, final AsyncHandler<DeleteUserPoolClientRequest, DeleteUserPoolClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteUserPoolClientResult>(){

            @Override
            public DeleteUserPoolClientResult call() throws Exception {
                DeleteUserPoolClientResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.deleteUserPoolClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserImportJobResult> describeUserImportJobAsync(DescribeUserImportJobRequest request) {
        return this.describeUserImportJobAsync(request, null);
    }

    @Override
    public Future<DescribeUserImportJobResult> describeUserImportJobAsync(final DescribeUserImportJobRequest request, final AsyncHandler<DescribeUserImportJobRequest, DescribeUserImportJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeUserImportJobResult>(){

            @Override
            public DescribeUserImportJobResult call() throws Exception {
                DescribeUserImportJobResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.describeUserImportJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserPoolResult> describeUserPoolAsync(DescribeUserPoolRequest request) {
        return this.describeUserPoolAsync(request, null);
    }

    @Override
    public Future<DescribeUserPoolResult> describeUserPoolAsync(final DescribeUserPoolRequest request, final AsyncHandler<DescribeUserPoolRequest, DescribeUserPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeUserPoolResult>(){

            @Override
            public DescribeUserPoolResult call() throws Exception {
                DescribeUserPoolResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.describeUserPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserPoolClientResult> describeUserPoolClientAsync(DescribeUserPoolClientRequest request) {
        return this.describeUserPoolClientAsync(request, null);
    }

    @Override
    public Future<DescribeUserPoolClientResult> describeUserPoolClientAsync(final DescribeUserPoolClientRequest request, final AsyncHandler<DescribeUserPoolClientRequest, DescribeUserPoolClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeUserPoolClientResult>(){

            @Override
            public DescribeUserPoolClientResult call() throws Exception {
                DescribeUserPoolClientResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.describeUserPoolClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ForgetDeviceResult> forgetDeviceAsync(ForgetDeviceRequest request) {
        return this.forgetDeviceAsync(request, null);
    }

    @Override
    public Future<ForgetDeviceResult> forgetDeviceAsync(final ForgetDeviceRequest request, final AsyncHandler<ForgetDeviceRequest, ForgetDeviceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ForgetDeviceResult>(){

            @Override
            public ForgetDeviceResult call() throws Exception {
                ForgetDeviceResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.forgetDevice(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ForgotPasswordResult> forgotPasswordAsync(ForgotPasswordRequest request) {
        return this.forgotPasswordAsync(request, null);
    }

    @Override
    public Future<ForgotPasswordResult> forgotPasswordAsync(final ForgotPasswordRequest request, final AsyncHandler<ForgotPasswordRequest, ForgotPasswordResult> asyncHandler) {
        return this.executorService.submit(new Callable<ForgotPasswordResult>(){

            @Override
            public ForgotPasswordResult call() throws Exception {
                ForgotPasswordResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.forgotPassword(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCSVHeaderResult> getCSVHeaderAsync(GetCSVHeaderRequest request) {
        return this.getCSVHeaderAsync(request, null);
    }

    @Override
    public Future<GetCSVHeaderResult> getCSVHeaderAsync(final GetCSVHeaderRequest request, final AsyncHandler<GetCSVHeaderRequest, GetCSVHeaderResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCSVHeaderResult>(){

            @Override
            public GetCSVHeaderResult call() throws Exception {
                GetCSVHeaderResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.getCSVHeader(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDeviceResult> getDeviceAsync(GetDeviceRequest request) {
        return this.getDeviceAsync(request, null);
    }

    @Override
    public Future<GetDeviceResult> getDeviceAsync(final GetDeviceRequest request, final AsyncHandler<GetDeviceRequest, GetDeviceResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDeviceResult>(){

            @Override
            public GetDeviceResult call() throws Exception {
                GetDeviceResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.getDevice(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUserResult> getUserAsync(GetUserRequest request) {
        return this.getUserAsync(request, null);
    }

    @Override
    public Future<GetUserResult> getUserAsync(final GetUserRequest request, final AsyncHandler<GetUserRequest, GetUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetUserResult>(){

            @Override
            public GetUserResult call() throws Exception {
                GetUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.getUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUserAttributeVerificationCodeResult> getUserAttributeVerificationCodeAsync(GetUserAttributeVerificationCodeRequest request) {
        return this.getUserAttributeVerificationCodeAsync(request, null);
    }

    @Override
    public Future<GetUserAttributeVerificationCodeResult> getUserAttributeVerificationCodeAsync(final GetUserAttributeVerificationCodeRequest request, final AsyncHandler<GetUserAttributeVerificationCodeRequest, GetUserAttributeVerificationCodeResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetUserAttributeVerificationCodeResult>(){

            @Override
            public GetUserAttributeVerificationCodeResult call() throws Exception {
                GetUserAttributeVerificationCodeResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.getUserAttributeVerificationCode(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GlobalSignOutResult> globalSignOutAsync(GlobalSignOutRequest request) {
        return this.globalSignOutAsync(request, null);
    }

    @Override
    public Future<GlobalSignOutResult> globalSignOutAsync(final GlobalSignOutRequest request, final AsyncHandler<GlobalSignOutRequest, GlobalSignOutResult> asyncHandler) {
        return this.executorService.submit(new Callable<GlobalSignOutResult>(){

            @Override
            public GlobalSignOutResult call() throws Exception {
                GlobalSignOutResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.globalSignOut(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InitiateAuthResult> initiateAuthAsync(InitiateAuthRequest request) {
        return this.initiateAuthAsync(request, null);
    }

    @Override
    public Future<InitiateAuthResult> initiateAuthAsync(final InitiateAuthRequest request, final AsyncHandler<InitiateAuthRequest, InitiateAuthResult> asyncHandler) {
        return this.executorService.submit(new Callable<InitiateAuthResult>(){

            @Override
            public InitiateAuthResult call() throws Exception {
                InitiateAuthResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.initiateAuth(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(ListDevicesRequest request) {
        return this.listDevicesAsync(request, null);
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(final ListDevicesRequest request, final AsyncHandler<ListDevicesRequest, ListDevicesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDevicesResult>(){

            @Override
            public ListDevicesResult call() throws Exception {
                ListDevicesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.listDevices(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUserImportJobsResult> listUserImportJobsAsync(ListUserImportJobsRequest request) {
        return this.listUserImportJobsAsync(request, null);
    }

    @Override
    public Future<ListUserImportJobsResult> listUserImportJobsAsync(final ListUserImportJobsRequest request, final AsyncHandler<ListUserImportJobsRequest, ListUserImportJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListUserImportJobsResult>(){

            @Override
            public ListUserImportJobsResult call() throws Exception {
                ListUserImportJobsResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.listUserImportJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUserPoolClientsResult> listUserPoolClientsAsync(ListUserPoolClientsRequest request) {
        return this.listUserPoolClientsAsync(request, null);
    }

    @Override
    public Future<ListUserPoolClientsResult> listUserPoolClientsAsync(final ListUserPoolClientsRequest request, final AsyncHandler<ListUserPoolClientsRequest, ListUserPoolClientsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListUserPoolClientsResult>(){

            @Override
            public ListUserPoolClientsResult call() throws Exception {
                ListUserPoolClientsResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.listUserPoolClients(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUserPoolsResult> listUserPoolsAsync(ListUserPoolsRequest request) {
        return this.listUserPoolsAsync(request, null);
    }

    @Override
    public Future<ListUserPoolsResult> listUserPoolsAsync(final ListUserPoolsRequest request, final AsyncHandler<ListUserPoolsRequest, ListUserPoolsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListUserPoolsResult>(){

            @Override
            public ListUserPoolsResult call() throws Exception {
                ListUserPoolsResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.listUserPools(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request) {
        return this.listUsersAsync(request, null);
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(final ListUsersRequest request, final AsyncHandler<ListUsersRequest, ListUsersResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListUsersResult>(){

            @Override
            public ListUsersResult call() throws Exception {
                ListUsersResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.listUsers(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResendConfirmationCodeResult> resendConfirmationCodeAsync(ResendConfirmationCodeRequest request) {
        return this.resendConfirmationCodeAsync(request, null);
    }

    @Override
    public Future<ResendConfirmationCodeResult> resendConfirmationCodeAsync(final ResendConfirmationCodeRequest request, final AsyncHandler<ResendConfirmationCodeRequest, ResendConfirmationCodeResult> asyncHandler) {
        return this.executorService.submit(new Callable<ResendConfirmationCodeResult>(){

            @Override
            public ResendConfirmationCodeResult call() throws Exception {
                ResendConfirmationCodeResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.resendConfirmationCode(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RespondToAuthChallengeResult> respondToAuthChallengeAsync(RespondToAuthChallengeRequest request) {
        return this.respondToAuthChallengeAsync(request, null);
    }

    @Override
    public Future<RespondToAuthChallengeResult> respondToAuthChallengeAsync(final RespondToAuthChallengeRequest request, final AsyncHandler<RespondToAuthChallengeRequest, RespondToAuthChallengeResult> asyncHandler) {
        return this.executorService.submit(new Callable<RespondToAuthChallengeResult>(){

            @Override
            public RespondToAuthChallengeResult call() throws Exception {
                RespondToAuthChallengeResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.respondToAuthChallenge(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetUserSettingsResult> setUserSettingsAsync(SetUserSettingsRequest request) {
        return this.setUserSettingsAsync(request, null);
    }

    @Override
    public Future<SetUserSettingsResult> setUserSettingsAsync(final SetUserSettingsRequest request, final AsyncHandler<SetUserSettingsRequest, SetUserSettingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetUserSettingsResult>(){

            @Override
            public SetUserSettingsResult call() throws Exception {
                SetUserSettingsResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.setUserSettings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SignUpResult> signUpAsync(SignUpRequest request) {
        return this.signUpAsync(request, null);
    }

    @Override
    public Future<SignUpResult> signUpAsync(final SignUpRequest request, final AsyncHandler<SignUpRequest, SignUpResult> asyncHandler) {
        return this.executorService.submit(new Callable<SignUpResult>(){

            @Override
            public SignUpResult call() throws Exception {
                SignUpResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.signUp(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartUserImportJobResult> startUserImportJobAsync(StartUserImportJobRequest request) {
        return this.startUserImportJobAsync(request, null);
    }

    @Override
    public Future<StartUserImportJobResult> startUserImportJobAsync(final StartUserImportJobRequest request, final AsyncHandler<StartUserImportJobRequest, StartUserImportJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartUserImportJobResult>(){

            @Override
            public StartUserImportJobResult call() throws Exception {
                StartUserImportJobResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.startUserImportJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopUserImportJobResult> stopUserImportJobAsync(StopUserImportJobRequest request) {
        return this.stopUserImportJobAsync(request, null);
    }

    @Override
    public Future<StopUserImportJobResult> stopUserImportJobAsync(final StopUserImportJobRequest request, final AsyncHandler<StopUserImportJobRequest, StopUserImportJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopUserImportJobResult>(){

            @Override
            public StopUserImportJobResult call() throws Exception {
                StopUserImportJobResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.stopUserImportJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDeviceStatusResult> updateDeviceStatusAsync(UpdateDeviceStatusRequest request) {
        return this.updateDeviceStatusAsync(request, null);
    }

    @Override
    public Future<UpdateDeviceStatusResult> updateDeviceStatusAsync(final UpdateDeviceStatusRequest request, final AsyncHandler<UpdateDeviceStatusRequest, UpdateDeviceStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateDeviceStatusResult>(){

            @Override
            public UpdateDeviceStatusResult call() throws Exception {
                UpdateDeviceStatusResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.updateDeviceStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserAttributesResult> updateUserAttributesAsync(UpdateUserAttributesRequest request) {
        return this.updateUserAttributesAsync(request, null);
    }

    @Override
    public Future<UpdateUserAttributesResult> updateUserAttributesAsync(final UpdateUserAttributesRequest request, final AsyncHandler<UpdateUserAttributesRequest, UpdateUserAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateUserAttributesResult>(){

            @Override
            public UpdateUserAttributesResult call() throws Exception {
                UpdateUserAttributesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.updateUserAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserPoolResult> updateUserPoolAsync(UpdateUserPoolRequest request) {
        return this.updateUserPoolAsync(request, null);
    }

    @Override
    public Future<UpdateUserPoolResult> updateUserPoolAsync(final UpdateUserPoolRequest request, final AsyncHandler<UpdateUserPoolRequest, UpdateUserPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateUserPoolResult>(){

            @Override
            public UpdateUserPoolResult call() throws Exception {
                UpdateUserPoolResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.updateUserPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserPoolClientResult> updateUserPoolClientAsync(UpdateUserPoolClientRequest request) {
        return this.updateUserPoolClientAsync(request, null);
    }

    @Override
    public Future<UpdateUserPoolClientResult> updateUserPoolClientAsync(final UpdateUserPoolClientRequest request, final AsyncHandler<UpdateUserPoolClientRequest, UpdateUserPoolClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateUserPoolClientResult>(){

            @Override
            public UpdateUserPoolClientResult call() throws Exception {
                UpdateUserPoolClientResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.updateUserPoolClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<VerifyUserAttributeResult> verifyUserAttributeAsync(VerifyUserAttributeRequest request) {
        return this.verifyUserAttributeAsync(request, null);
    }

    @Override
    public Future<VerifyUserAttributeResult> verifyUserAttributeAsync(final VerifyUserAttributeRequest request, final AsyncHandler<VerifyUserAttributeRequest, VerifyUserAttributeResult> asyncHandler) {
        return this.executorService.submit(new Callable<VerifyUserAttributeResult>(){

            @Override
            public VerifyUserAttributeResult call() throws Exception {
                VerifyUserAttributeResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.verifyUserAttribute(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

