/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListDistributionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListDistributionsRequestMarshaller
implements Marshaller<Request<ListDistributionsRequest>, ListDistributionsRequest> {
    @Override
    public Request<ListDistributionsRequest> marshall(ListDistributionsRequest listDistributionsRequest) {
        if (listDistributionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDistributionsRequest> request = new DefaultRequest<ListDistributionsRequest>(listDistributionsRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2016-09-07/distribution";
        request.setResourcePath(uriResourcePath);
        if (listDistributionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listDistributionsRequest.getMarker()));
        }
        if (listDistributionsRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString(listDistributionsRequest.getMaxItems()));
        }
        return request;
    }
}

