/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.CachedMethods;
import com.amazonaws.services.cloudfront.model.Method;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AllowedMethods
implements Serializable,
Cloneable {
    private Integer quantity;
    private SdkInternalList<String> items;
    private CachedMethods cachedMethods;

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public AllowedMethods withQuantity(Integer quantity) {
        this.setQuantity(quantity);
        return this;
    }

    public List<String> getItems() {
        if (this.items == null) {
            this.items = new SdkInternalList();
        }
        return this.items;
    }

    public void setItems(Collection<String> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new SdkInternalList<String>(items);
    }

    public AllowedMethods withItems(String ... items) {
        if (this.items == null) {
            this.setItems(new SdkInternalList<String>(items.length));
        }
        for (String ele : items) {
            this.items.add(ele);
        }
        return this;
    }

    public AllowedMethods withItems(Collection<String> items) {
        this.setItems(items);
        return this;
    }

    public AllowedMethods withItems(Method ... items) {
        SdkInternalList<String> itemsCopy = new SdkInternalList<String>(items.length);
        for (Method value : items) {
            itemsCopy.add(value.toString());
        }
        if (this.getItems() == null) {
            this.setItems(itemsCopy);
        } else {
            this.getItems().addAll(itemsCopy);
        }
        return this;
    }

    public void setCachedMethods(CachedMethods cachedMethods) {
        this.cachedMethods = cachedMethods;
    }

    public CachedMethods getCachedMethods() {
        return this.cachedMethods;
    }

    public AllowedMethods withCachedMethods(CachedMethods cachedMethods) {
        this.setCachedMethods(cachedMethods);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQuantity() != null) {
            sb.append("Quantity: " + this.getQuantity() + ",");
        }
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems() + ",");
        }
        if (this.getCachedMethods() != null) {
            sb.append("CachedMethods: " + this.getCachedMethods());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowedMethods)) {
            return false;
        }
        AllowedMethods other = (AllowedMethods)obj;
        if (other.getQuantity() == null ^ this.getQuantity() == null) {
            return false;
        }
        if (other.getQuantity() != null && !other.getQuantity().equals(this.getQuantity())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !other.getItems().equals(this.getItems())) {
            return false;
        }
        if (other.getCachedMethods() == null ^ this.getCachedMethods() == null) {
            return false;
        }
        return other.getCachedMethods() == null || other.getCachedMethods().equals(this.getCachedMethods());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQuantity() == null ? 0 : this.getQuantity().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        hashCode = 31 * hashCode + (this.getCachedMethods() == null ? 0 : this.getCachedMethods().hashCode());
        return hashCode;
    }

    public AllowedMethods clone() {
        try {
            return (AllowedMethods)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

