/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.ParameterObject;
import com.amazonaws.services.datapipeline.model.ParameterValue;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GetPipelineDefinitionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<PipelineObject> pipelineObjects;
    private SdkInternalList<ParameterObject> parameterObjects;
    private SdkInternalList<ParameterValue> parameterValues;

    public List<PipelineObject> getPipelineObjects() {
        if (this.pipelineObjects == null) {
            this.pipelineObjects = new SdkInternalList();
        }
        return this.pipelineObjects;
    }

    public void setPipelineObjects(Collection<PipelineObject> pipelineObjects) {
        if (pipelineObjects == null) {
            this.pipelineObjects = null;
            return;
        }
        this.pipelineObjects = new SdkInternalList<PipelineObject>(pipelineObjects);
    }

    public GetPipelineDefinitionResult withPipelineObjects(PipelineObject ... pipelineObjects) {
        if (this.pipelineObjects == null) {
            this.setPipelineObjects(new SdkInternalList<PipelineObject>(pipelineObjects.length));
        }
        for (PipelineObject ele : pipelineObjects) {
            this.pipelineObjects.add(ele);
        }
        return this;
    }

    public GetPipelineDefinitionResult withPipelineObjects(Collection<PipelineObject> pipelineObjects) {
        this.setPipelineObjects(pipelineObjects);
        return this;
    }

    public List<ParameterObject> getParameterObjects() {
        if (this.parameterObjects == null) {
            this.parameterObjects = new SdkInternalList();
        }
        return this.parameterObjects;
    }

    public void setParameterObjects(Collection<ParameterObject> parameterObjects) {
        if (parameterObjects == null) {
            this.parameterObjects = null;
            return;
        }
        this.parameterObjects = new SdkInternalList<ParameterObject>(parameterObjects);
    }

    public GetPipelineDefinitionResult withParameterObjects(ParameterObject ... parameterObjects) {
        if (this.parameterObjects == null) {
            this.setParameterObjects(new SdkInternalList<ParameterObject>(parameterObjects.length));
        }
        for (ParameterObject ele : parameterObjects) {
            this.parameterObjects.add(ele);
        }
        return this;
    }

    public GetPipelineDefinitionResult withParameterObjects(Collection<ParameterObject> parameterObjects) {
        this.setParameterObjects(parameterObjects);
        return this;
    }

    public List<ParameterValue> getParameterValues() {
        if (this.parameterValues == null) {
            this.parameterValues = new SdkInternalList();
        }
        return this.parameterValues;
    }

    public void setParameterValues(Collection<ParameterValue> parameterValues) {
        if (parameterValues == null) {
            this.parameterValues = null;
            return;
        }
        this.parameterValues = new SdkInternalList<ParameterValue>(parameterValues);
    }

    public GetPipelineDefinitionResult withParameterValues(ParameterValue ... parameterValues) {
        if (this.parameterValues == null) {
            this.setParameterValues(new SdkInternalList<ParameterValue>(parameterValues.length));
        }
        for (ParameterValue ele : parameterValues) {
            this.parameterValues.add(ele);
        }
        return this;
    }

    public GetPipelineDefinitionResult withParameterValues(Collection<ParameterValue> parameterValues) {
        this.setParameterValues(parameterValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineObjects() != null) {
            sb.append("PipelineObjects: " + this.getPipelineObjects() + ",");
        }
        if (this.getParameterObjects() != null) {
            sb.append("ParameterObjects: " + this.getParameterObjects() + ",");
        }
        if (this.getParameterValues() != null) {
            sb.append("ParameterValues: " + this.getParameterValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineDefinitionResult)) {
            return false;
        }
        GetPipelineDefinitionResult other = (GetPipelineDefinitionResult)obj;
        if (other.getPipelineObjects() == null ^ this.getPipelineObjects() == null) {
            return false;
        }
        if (other.getPipelineObjects() != null && !other.getPipelineObjects().equals(this.getPipelineObjects())) {
            return false;
        }
        if (other.getParameterObjects() == null ^ this.getParameterObjects() == null) {
            return false;
        }
        if (other.getParameterObjects() != null && !other.getParameterObjects().equals(this.getParameterObjects())) {
            return false;
        }
        if (other.getParameterValues() == null ^ this.getParameterValues() == null) {
            return false;
        }
        return other.getParameterValues() == null || other.getParameterValues().equals(this.getParameterValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineObjects() == null ? 0 : this.getPipelineObjects().hashCode());
        hashCode = 31 * hashCode + (this.getParameterObjects() == null ? 0 : this.getParameterObjects().hashCode());
        hashCode = 31 * hashCode + (this.getParameterValues() == null ? 0 : this.getParameterValues().hashCode());
        return hashCode;
    }

    public GetPipelineDefinitionResult clone() {
        try {
            return (GetPipelineDefinitionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

