/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteVaultAccessPolicyRequestMarshaller
implements Marshaller<Request<DeleteVaultAccessPolicyRequest>, DeleteVaultAccessPolicyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteVaultAccessPolicyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteVaultAccessPolicyRequest> marshall(DeleteVaultAccessPolicyRequest deleteVaultAccessPolicyRequest) {
        if (deleteVaultAccessPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteVaultAccessPolicyRequest> request = new DefaultRequest<DeleteVaultAccessPolicyRequest>(deleteVaultAccessPolicyRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/access-policy";
        uriResourcePath = uriResourcePath.replace("{accountId}", deleteVaultAccessPolicyRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteVaultAccessPolicyRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", deleteVaultAccessPolicyRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteVaultAccessPolicyRequest.getVaultName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

