/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.workspaces.model.Workspace;
import com.amazonaws.services.workspaces.model.transform.WorkspacePropertiesJsonMarshaller;

public class WorkspaceJsonMarshaller {
    private static WorkspaceJsonMarshaller instance;

    public void marshall(Workspace workspace, StructuredJsonGenerator jsonGenerator) {
        if (workspace == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (workspace.getWorkspaceId() != null) {
                jsonGenerator.writeFieldName("WorkspaceId").writeValue(workspace.getWorkspaceId());
            }
            if (workspace.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(workspace.getDirectoryId());
            }
            if (workspace.getUserName() != null) {
                jsonGenerator.writeFieldName("UserName").writeValue(workspace.getUserName());
            }
            if (workspace.getIpAddress() != null) {
                jsonGenerator.writeFieldName("IpAddress").writeValue(workspace.getIpAddress());
            }
            if (workspace.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(workspace.getState());
            }
            if (workspace.getBundleId() != null) {
                jsonGenerator.writeFieldName("BundleId").writeValue(workspace.getBundleId());
            }
            if (workspace.getSubnetId() != null) {
                jsonGenerator.writeFieldName("SubnetId").writeValue(workspace.getSubnetId());
            }
            if (workspace.getErrorMessage() != null) {
                jsonGenerator.writeFieldName("ErrorMessage").writeValue(workspace.getErrorMessage());
            }
            if (workspace.getErrorCode() != null) {
                jsonGenerator.writeFieldName("ErrorCode").writeValue(workspace.getErrorCode());
            }
            if (workspace.getComputerName() != null) {
                jsonGenerator.writeFieldName("ComputerName").writeValue(workspace.getComputerName());
            }
            if (workspace.getVolumeEncryptionKey() != null) {
                jsonGenerator.writeFieldName("VolumeEncryptionKey").writeValue(workspace.getVolumeEncryptionKey());
            }
            if (workspace.getUserVolumeEncryptionEnabled() != null) {
                jsonGenerator.writeFieldName("UserVolumeEncryptionEnabled").writeValue(workspace.getUserVolumeEncryptionEnabled());
            }
            if (workspace.getRootVolumeEncryptionEnabled() != null) {
                jsonGenerator.writeFieldName("RootVolumeEncryptionEnabled").writeValue(workspace.getRootVolumeEncryptionEnabled());
            }
            if (workspace.getWorkspaceProperties() != null) {
                jsonGenerator.writeFieldName("WorkspaceProperties");
                WorkspacePropertiesJsonMarshaller.getInstance().marshall(workspace.getWorkspaceProperties(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkspaceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkspaceJsonMarshaller();
        }
        return instance;
    }
}

