/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest;
import com.amazonaws.services.kinesisanalytics.model.transform.ReferenceDataSourceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AddApplicationReferenceDataSourceRequestMarshaller
implements Marshaller<Request<AddApplicationReferenceDataSourceRequest>, AddApplicationReferenceDataSourceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AddApplicationReferenceDataSourceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AddApplicationReferenceDataSourceRequest> marshall(AddApplicationReferenceDataSourceRequest addApplicationReferenceDataSourceRequest) {
        if (addApplicationReferenceDataSourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddApplicationReferenceDataSourceRequest> request = new DefaultRequest<AddApplicationReferenceDataSourceRequest>(addApplicationReferenceDataSourceRequest, "AmazonKinesisAnalytics");
        request.addHeader("X-Amz-Target", "KinesisAnalytics_20150814.AddApplicationReferenceDataSource");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (addApplicationReferenceDataSourceRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("ApplicationName").writeValue(addApplicationReferenceDataSourceRequest.getApplicationName());
            }
            if (addApplicationReferenceDataSourceRequest.getCurrentApplicationVersionId() != null) {
                jsonGenerator.writeFieldName("CurrentApplicationVersionId").writeValue(addApplicationReferenceDataSourceRequest.getCurrentApplicationVersionId());
            }
            if (addApplicationReferenceDataSourceRequest.getReferenceDataSource() != null) {
                jsonGenerator.writeFieldName("ReferenceDataSource");
                ReferenceDataSourceJsonMarshaller.getInstance().marshall(addApplicationReferenceDataSourceRequest.getReferenceDataSource(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

