/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeTargetGroupsRequestMarshaller
implements Marshaller<Request<DescribeTargetGroupsRequest>, DescribeTargetGroupsRequest> {
    @Override
    public Request<DescribeTargetGroupsRequest> marshall(DescribeTargetGroupsRequest describeTargetGroupsRequest) {
        List<String> namesList;
        List<String> targetGroupArnsList;
        if (describeTargetGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTargetGroupsRequest> request = new DefaultRequest<DescribeTargetGroupsRequest>(describeTargetGroupsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeTargetGroups");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTargetGroupsRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString(describeTargetGroupsRequest.getLoadBalancerArn()));
        }
        if ((targetGroupArnsList = describeTargetGroupsRequest.getTargetGroupArns()) != null) {
            if (targetGroupArnsList.isEmpty()) {
                request.addParameter("TargetGroupArns", "");
            } else {
                int targetGroupArnsListIndex = 1;
                for (String targetGroupArnsListValue : targetGroupArnsList) {
                    if (targetGroupArnsListValue != null) {
                        request.addParameter("TargetGroupArns.member." + targetGroupArnsListIndex, StringUtils.fromString(targetGroupArnsListValue));
                    }
                    ++targetGroupArnsListIndex;
                }
            }
        }
        if ((namesList = describeTargetGroupsRequest.getNames()) != null) {
            if (namesList.isEmpty()) {
                request.addParameter("Names", "");
            } else {
                int namesListIndex = 1;
                for (String namesListValue : namesList) {
                    if (namesListValue != null) {
                        request.addParameter("Names.member." + namesListIndex, StringUtils.fromString(namesListValue));
                    }
                    ++namesListIndex;
                }
            }
        }
        if (describeTargetGroupsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeTargetGroupsRequest.getMarker()));
        }
        if (describeTargetGroupsRequest.getPageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger(describeTargetGroupsRequest.getPageSize()));
        }
        return request;
    }
}

