/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeListenersRequestMarshaller
implements Marshaller<Request<DescribeListenersRequest>, DescribeListenersRequest> {
    @Override
    public Request<DescribeListenersRequest> marshall(DescribeListenersRequest describeListenersRequest) {
        List<String> listenerArnsList;
        if (describeListenersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeListenersRequest> request = new DefaultRequest<DescribeListenersRequest>(describeListenersRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeListeners");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeListenersRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString(describeListenersRequest.getLoadBalancerArn()));
        }
        if ((listenerArnsList = describeListenersRequest.getListenerArns()) != null) {
            if (listenerArnsList.isEmpty()) {
                request.addParameter("ListenerArns", "");
            } else {
                int listenerArnsListIndex = 1;
                for (String listenerArnsListValue : listenerArnsList) {
                    if (listenerArnsListValue != null) {
                        request.addParameter("ListenerArns.member." + listenerArnsListIndex, StringUtils.fromString(listenerArnsListValue));
                    }
                    ++listenerArnsListIndex;
                }
            }
        }
        if (describeListenersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeListenersRequest.getMarker()));
        }
        if (describeListenersRequest.getPageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger(describeListenersRequest.getPageSize()));
        }
        return request;
    }
}

