/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TerminateEnvironmentRequestMarshaller
implements Marshaller<Request<TerminateEnvironmentRequest>, TerminateEnvironmentRequest> {
    @Override
    public Request<TerminateEnvironmentRequest> marshall(TerminateEnvironmentRequest terminateEnvironmentRequest) {
        if (terminateEnvironmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TerminateEnvironmentRequest> request = new DefaultRequest<TerminateEnvironmentRequest>(terminateEnvironmentRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "TerminateEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (terminateEnvironmentRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString(terminateEnvironmentRequest.getEnvironmentId()));
        }
        if (terminateEnvironmentRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString(terminateEnvironmentRequest.getEnvironmentName()));
        }
        if (terminateEnvironmentRequest.getTerminateResources() != null) {
            request.addParameter("TerminateResources", StringUtils.fromBoolean(terminateEnvironmentRequest.getTerminateResources()));
        }
        if (terminateEnvironmentRequest.getForceTerminate() != null) {
            request.addParameter("ForceTerminate", StringUtils.fromBoolean(terminateEnvironmentRequest.getForceTerminate()));
        }
        return request;
    }
}

