/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.NetworkMode;
import com.amazonaws.services.ecs.model.Volume;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RegisterTaskDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String family;
    private String taskRoleArn;
    private String networkMode;
    private SdkInternalList<ContainerDefinition> containerDefinitions;
    private SdkInternalList<Volume> volumes;

    public void setFamily(String family) {
        this.family = family;
    }

    public String getFamily() {
        return this.family;
    }

    public RegisterTaskDefinitionRequest withFamily(String family) {
        this.setFamily(family);
        return this;
    }

    public void setTaskRoleArn(String taskRoleArn) {
        this.taskRoleArn = taskRoleArn;
    }

    public String getTaskRoleArn() {
        return this.taskRoleArn;
    }

    public RegisterTaskDefinitionRequest withTaskRoleArn(String taskRoleArn) {
        this.setTaskRoleArn(taskRoleArn);
        return this;
    }

    public void setNetworkMode(String networkMode) {
        this.networkMode = networkMode;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public RegisterTaskDefinitionRequest withNetworkMode(String networkMode) {
        this.setNetworkMode(networkMode);
        return this;
    }

    public void setNetworkMode(NetworkMode networkMode) {
        this.networkMode = networkMode.toString();
    }

    public RegisterTaskDefinitionRequest withNetworkMode(NetworkMode networkMode) {
        this.setNetworkMode(networkMode);
        return this;
    }

    public List<ContainerDefinition> getContainerDefinitions() {
        if (this.containerDefinitions == null) {
            this.containerDefinitions = new SdkInternalList();
        }
        return this.containerDefinitions;
    }

    public void setContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
            return;
        }
        this.containerDefinitions = new SdkInternalList<ContainerDefinition>(containerDefinitions);
    }

    public RegisterTaskDefinitionRequest withContainerDefinitions(ContainerDefinition ... containerDefinitions) {
        if (this.containerDefinitions == null) {
            this.setContainerDefinitions(new SdkInternalList<ContainerDefinition>(containerDefinitions.length));
        }
        for (ContainerDefinition ele : containerDefinitions) {
            this.containerDefinitions.add(ele);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        this.setContainerDefinitions(containerDefinitions);
        return this;
    }

    public List<Volume> getVolumes() {
        if (this.volumes == null) {
            this.volumes = new SdkInternalList();
        }
        return this.volumes;
    }

    public void setVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        this.volumes = new SdkInternalList<Volume>(volumes);
    }

    public RegisterTaskDefinitionRequest withVolumes(Volume ... volumes) {
        if (this.volumes == null) {
            this.setVolumes(new SdkInternalList<Volume>(volumes.length));
        }
        for (Volume ele : volumes) {
            this.volumes.add(ele);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withVolumes(Collection<Volume> volumes) {
        this.setVolumes(volumes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFamily() != null) {
            sb.append("Family: " + this.getFamily() + ",");
        }
        if (this.getTaskRoleArn() != null) {
            sb.append("TaskRoleArn: " + this.getTaskRoleArn() + ",");
        }
        if (this.getNetworkMode() != null) {
            sb.append("NetworkMode: " + this.getNetworkMode() + ",");
        }
        if (this.getContainerDefinitions() != null) {
            sb.append("ContainerDefinitions: " + this.getContainerDefinitions() + ",");
        }
        if (this.getVolumes() != null) {
            sb.append("Volumes: " + this.getVolumes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskDefinitionRequest)) {
            return false;
        }
        RegisterTaskDefinitionRequest other = (RegisterTaskDefinitionRequest)obj;
        if (other.getFamily() == null ^ this.getFamily() == null) {
            return false;
        }
        if (other.getFamily() != null && !other.getFamily().equals(this.getFamily())) {
            return false;
        }
        if (other.getTaskRoleArn() == null ^ this.getTaskRoleArn() == null) {
            return false;
        }
        if (other.getTaskRoleArn() != null && !other.getTaskRoleArn().equals(this.getTaskRoleArn())) {
            return false;
        }
        if (other.getNetworkMode() == null ^ this.getNetworkMode() == null) {
            return false;
        }
        if (other.getNetworkMode() != null && !other.getNetworkMode().equals(this.getNetworkMode())) {
            return false;
        }
        if (other.getContainerDefinitions() == null ^ this.getContainerDefinitions() == null) {
            return false;
        }
        if (other.getContainerDefinitions() != null && !other.getContainerDefinitions().equals(this.getContainerDefinitions())) {
            return false;
        }
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        return other.getVolumes() == null || other.getVolumes().equals(this.getVolumes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFamily() == null ? 0 : this.getFamily().hashCode());
        hashCode = 31 * hashCode + (this.getTaskRoleArn() == null ? 0 : this.getTaskRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkMode() == null ? 0 : this.getNetworkMode().hashCode());
        hashCode = 31 * hashCode + (this.getContainerDefinitions() == null ? 0 : this.getContainerDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        return hashCode;
    }

    @Override
    public RegisterTaskDefinitionRequest clone() {
        return (RegisterTaskDefinitionRequest)super.clone();
    }
}

