/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverterFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.util.DateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;

@SdkInternalApi
final class StandardTypeConverters
implements DynamoDBTypeConverterFactory {
    private static final DynamoDBTypeConverterFactory FACTORY = new StandardTypeConverters();
    private static final LinkedHashMap<DynamoDBTypeConverterFactory.OverrideFactory.Key<?, ?>, Converter<?, ?>> ALL = new LinkedHashMap();

    StandardTypeConverters() {
    }

    static <S, T> DynamoDBTypeConverter<S, T> of(Class<S> sourceType, Class<T> targetType) {
        return StandardTypeConverters.factory().getConverter(sourceType, targetType);
    }

    static DynamoDBTypeConverterFactory factory() {
        return FACTORY;
    }

    @Override
    public <S, T> DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
        return Scalar.join(sourceType, targetType);
    }

    static {
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<BigDecimal, String>(BigDecimal.class, String.class), new Converter<BigDecimal, String>(){

            @Override
            public final BigDecimal convert(String o) {
                return new BigDecimal(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<BigInteger, String>(BigInteger.class, String.class), new Converter<BigInteger, String>(){

            @Override
            public final BigInteger convert(String o) {
                return new BigInteger(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Boolean, String>(Boolean.class, String.class), new Converter<Boolean, String>(){

            @Override
            public final Boolean convert(String o) {
                return "0".equals(o) ? Boolean.FALSE : ("1".equals(o) ? Boolean.TRUE : Boolean.valueOf(o));
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Byte, Number>(Byte.class, Number.class), new Converter<Byte, Number>(){

            @Override
            public final Byte convert(Number o) {
                return o.byteValue();
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Byte, String>(Byte.class, String.class), new Converter<Byte, String>(){

            @Override
            public final Byte convert(String o) {
                return Byte.valueOf(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<byte[], ByteBuffer>(byte[].class, ByteBuffer.class), new Converter<byte[], ByteBuffer>(){

            @Override
            public final byte[] convert(ByteBuffer o) {
                if (o.hasArray()) {
                    return o.array();
                }
                byte[] value = new byte[o.remaining()];
                o.get(value);
                return value;
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<byte[], String>(byte[].class, String.class), new Converter<byte[], String>(){

            @Override
            public final byte[] convert(String o) {
                return o.getBytes(Charset.forName("UTF-8"));
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<ByteBuffer, byte[]>(ByteBuffer.class, byte[].class), new Converter<ByteBuffer, byte[]>(){

            @Override
            public final ByteBuffer convert(byte[] o) {
                return ByteBuffer.wrap(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<ByteBuffer, UUID>(ByteBuffer.class, UUID.class), new Converter<ByteBuffer, UUID>(){

            @Override
            public final ByteBuffer convert(UUID o) {
                ByteBuffer value = ByteBuffer.allocate(16);
                value.putLong(o.getMostSignificantBits()).putLong(o.getLeastSignificantBits());
                value.position(0);
                return value;
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Calendar, Date>(Calendar.class, Date.class), new Converter<Calendar, Date>(){

            @Override
            public final Calendar convert(Date o) {
                Calendar value = Calendar.getInstance();
                value.setTime(o);
                return value;
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Character, String>(Character.class, String.class), new Converter<Character, String>(){

            @Override
            public final Character convert(String o) {
                return Character.valueOf(o.charAt(0));
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Currency, String>(Currency.class, String.class), new Converter<Currency, String>(){

            @Override
            public final Currency convert(String o) {
                return Currency.getInstance(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Date, Calendar>(Date.class, Calendar.class), new Converter<Date, Calendar>(){

            @Override
            public final Date convert(Calendar o) {
                return o.getTime();
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Date, Long>(Date.class, Long.class), new Converter<Date, Long>(){

            @Override
            public final Date convert(Long o) {
                return new Date(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Date, String>(Date.class, String.class), new Converter<Date, String>(){

            @Override
            public final Date convert(String o) {
                return DateUtils.parseISO8601Date(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Double, Number>(Double.class, Number.class), new Converter<Double, Number>(){

            @Override
            public final Double convert(Number o) {
                return o.doubleValue();
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Double, String>(Double.class, String.class), new Converter<Double, String>(){

            @Override
            public final Double convert(String o) {
                return Double.valueOf(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Float, Number>(Float.class, Number.class), new Converter<Float, Number>(){

            @Override
            public final Float convert(Number o) {
                return Float.valueOf(o.floatValue());
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Float, String>(Float.class, String.class), new Converter<Float, String>(){

            @Override
            public final Float convert(String o) {
                return Float.valueOf(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Integer, Number>(Integer.class, Number.class), new Converter<Integer, Number>(){

            @Override
            public final Integer convert(Number o) {
                return o.intValue();
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Integer, String>(Integer.class, String.class), new Converter<Integer, String>(){

            @Override
            public final Integer convert(String o) {
                return Integer.valueOf(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Locale, String>(Locale.class, String.class), new Converter<Locale, String>(){

            @Override
            public final Locale convert(String o) {
                String[] value = o.split("-", 3);
                if (value.length == 3) {
                    return new Locale(value[0], value[1], value[2]);
                }
                if (value.length == 2) {
                    return new Locale(value[0], value[1]);
                }
                return new Locale(value[0]);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Long, Date>(Long.class, Date.class), new Converter<Long, Date>(){

            @Override
            public final Long convert(Date o) {
                return o.getTime();
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Long, Number>(Long.class, Number.class), new Converter<Long, Number>(){

            @Override
            public final Long convert(Number o) {
                return o.longValue();
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Long, String>(Long.class, String.class), new Converter<Long, String>(){

            @Override
            public final Long convert(String o) {
                return Long.valueOf(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Short, Number>(Short.class, Number.class), new Converter<Short, Number>(){

            @Override
            public final Short convert(Number o) {
                return o.shortValue();
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<Short, String>(Short.class, String.class), new Converter<Short, String>(){

            @Override
            public final Short convert(String o) {
                return Short.valueOf(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<String, Boolean>(String.class, Boolean.class), new Converter<String, Boolean>(){

            @Override
            public final String convert(Boolean o) {
                return Boolean.TRUE.equals(o) ? "1" : "0";
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<String, byte[]>(String.class, byte[].class), new Converter<String, byte[]>(){

            @Override
            public final String convert(byte[] o) {
                return new String(o, Charset.forName("UTF-8"));
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<String, Date>(String.class, Date.class), new Converter<String, Date>(){

            @Override
            public final String convert(Date o) {
                return DateUtils.formatISO8601Date(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<String, Enum>(String.class, Enum.class), new Converter<String, Enum>(){

            @Override
            public final String convert(Enum o) {
                return o.name();
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<String, Locale>(String.class, Locale.class), new Converter<String, Locale>(){

            @Override
            public final String convert(Locale o) {
                StringBuilder value = new StringBuilder(o.getLanguage());
                if (!o.getCountry().isEmpty() || !o.getVariant().isEmpty()) {
                    value.append("-").append(o.getCountry());
                }
                if (!o.getVariant().isEmpty()) {
                    value.append("-").append(o.getVariant());
                }
                return value.toString();
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<String, TimeZone>(String.class, TimeZone.class), new Converter<String, TimeZone>(){

            @Override
            public final String convert(TimeZone o) {
                return o.getID();
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<String, Object>(String.class, Object.class), new Converter<String, Object>(){

            @Override
            public final String convert(Object o) {
                return o.toString();
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<TimeZone, String>(TimeZone.class, String.class), new Converter<TimeZone, String>(){

            @Override
            public final TimeZone convert(String o) {
                return TimeZone.getTimeZone(o);
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<UUID, ByteBuffer>(UUID.class, ByteBuffer.class), new Converter<UUID, ByteBuffer>(){

            @Override
            public final UUID convert(ByteBuffer o) {
                return new UUID(o.getLong(), o.getLong());
            }
        });
        ALL.put(new DynamoDBTypeConverterFactory.OverrideFactory.Key<UUID, String>(UUID.class, String.class), new Converter<UUID, String>(){

            @Override
            public final UUID convert(String o) {
                return UUID.fromString(o);
            }
        });
    }

    private static final class ConverterMap<S>
    extends LinkedHashMap<Class<?>, Converter<S, ?>> {
        private final Class<S>[] types;

        private ConverterMap(Class<S> ... sourceTypes) {
            this.types = sourceTypes;
        }

        final <T> ConverterMap<S> withStandardTarget(Class<T> targetType, Class<?> ... joins) {
            Converter converter = null;
            for (int j = 0; j <= joins.length; ++j) {
                Class<Object> keySourceType = j == 0 ? this.types[0] : joins[j - 1];
                Class<T> keyTargetType = j == joins.length ? targetType : joins[j];
                Converter target = (Converter)ALL.get(new DynamoDBTypeConverterFactory.OverrideFactory.Key<S, T>(keySourceType, keyTargetType));
                converter = converter == null ? target : converter.join(target);
            }
            this.put(targetType, converter);
            return this;
        }

        final boolean isAssignableFrom(Class<?> sourceType) {
            for (Class<S> type : this.types) {
                if (!type.isAssignableFrom(sourceType)) continue;
                return true;
            }
            return false;
        }

        final <T> Converter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            for (Map.Entry entry : this.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(targetType)) continue;
                return (Converter)entry.getValue();
            }
            if (this.isAssignableFrom(targetType)) {
                return Converter.ANY;
            }
            throw new DynamoDBMappingException("type [" + targetType + "] is not supported; no conversion from " + sourceType);
        }
    }

    static abstract class Converter<S, T> {
        private static final Converter<Object, Object> ANY = new Converter<Object, Object>(){

            @Override
            public final Object convert(Object o) {
                return o;
            }
        };

        Converter() {
        }

        final <U> Converter<S, U> join(final Converter<T, U> target) {
            final Converter source = this;
            return new Converter<S, U>(){

                @Override
                public S convert(U o) {
                    return source.convert(target.convert(o));
                }
            };
        }

        public abstract S convert(T var1);
    }

    static final class Vector {
        Vector() {
        }

        static final class SET {
            SET() {
            }

            static <S, T> DynamoDBTypeConverter<List<S>, Set<T>> join(final DynamoDBTypeConverter<S, T> target) {
                return new DynamoDBTypeConverter<List<S>, Set<T>>(){

                    @Override
                    public List<S> convert(Set<T> o) {
                        return LIST.convert(o, target);
                    }

                    @Override
                    public Set<T> unconvert(List<S> o) {
                        return SET.unconvert(o, target);
                    }
                };
            }

            static <S, T> Set<T> unconvert(Collection<S> o, DynamoDBTypeConverter<S, T> scalar) {
                LinkedHashSet<T> vector = new LinkedHashSet<T>();
                for (S s : o) {
                    if (vector.add(scalar.unconvert(s))) continue;
                    throw new DynamoDBMappingException("duplicate value (" + s + ")");
                }
                return vector;
            }

            static boolean is(Class<?> sourceType) {
                return Set.class.isAssignableFrom(sourceType);
            }
        }

        static final class MAP {
            MAP() {
            }

            static <K, S, T> DynamoDBTypeConverter<Map<K, S>, Map<K, T>> join(final DynamoDBTypeConverter<S, T> scalar) {
                return new DynamoDBTypeConverter<Map<K, S>, Map<K, T>>(){

                    @Override
                    public final Map<K, S> convert(Map<K, T> o) {
                        return MAP.convert(o, scalar);
                    }

                    @Override
                    public final Map<K, T> unconvert(Map<K, S> o) {
                        return MAP.unconvert(o, scalar);
                    }
                };
            }

            static <K, S, T> Map<K, S> convert(Map<K, T> o, DynamoDBTypeConverter<S, T> scalar) {
                LinkedHashMap<K, S> vector = new LinkedHashMap<K, S>();
                for (Map.Entry<K, T> t : o.entrySet()) {
                    vector.put(t.getKey(), scalar.convert(t.getValue()));
                }
                return vector;
            }

            static <K, S, T> Map<K, T> unconvert(Map<K, S> o, DynamoDBTypeConverter<S, T> scalar) {
                LinkedHashMap<K, T> vector = new LinkedHashMap<K, T>();
                for (Map.Entry<K, S> s : o.entrySet()) {
                    vector.put(s.getKey(), scalar.unconvert(s.getValue()));
                }
                return vector;
            }

            static boolean is(Class<?> sourceType) {
                return Map.class.isAssignableFrom(sourceType);
            }
        }

        static final class LIST {
            LIST() {
            }

            static <S, T> DynamoDBTypeConverter<List<S>, List<T>> join(final DynamoDBTypeConverter<S, T> scalar) {
                return new DynamoDBTypeConverter<List<S>, List<T>>(){

                    @Override
                    public final List<S> convert(List<T> o) {
                        return LIST.convert(o, scalar);
                    }

                    @Override
                    public final List<T> unconvert(List<S> o) {
                        return LIST.unconvert(o, scalar);
                    }
                };
            }

            static <S, T> List<S> convert(Collection<T> o, DynamoDBTypeConverter<S, T> scalar) {
                ArrayList<S> vector = new ArrayList<S>(o.size());
                for (T t : o) {
                    vector.add(scalar.convert(t));
                }
                return vector;
            }

            static <S, T> List<T> unconvert(Collection<S> o, DynamoDBTypeConverter<S, T> scalar) {
                ArrayList<T> vector = new ArrayList<T>(o.size());
                for (S s : o) {
                    vector.add(scalar.unconvert(s));
                }
                return vector;
            }

            static boolean is(Class<?> sourceType) {
                return List.class.isAssignableFrom(sourceType);
            }
        }
    }

    static enum Scalar {
        BIG_DECIMAL(ScalarAttributeType.N, new ConverterMap<S>(new Class[]{BigDecimal.class}).withStandardTarget(String.class, new Class[0])),
        BIG_INTEGER(ScalarAttributeType.N, new ConverterMap<S>(new Class[]{BigInteger.class}).withStandardTarget(String.class, new Class[0])),
        BOOLEAN(ScalarAttributeType.N, new ConverterMap<S>(new Class[]{Boolean.class, Boolean.TYPE}).withStandardTarget(String.class, new Class[0])),
        BYTE(ScalarAttributeType.N, new ConverterMap<S>(new Class[]{Byte.class, Byte.TYPE}).withStandardTarget(Number.class, new Class[0]).withStandardTarget(String.class, new Class[0])),
        BYTE_ARRAY(ScalarAttributeType.B, new ConverterMap<S>(new Class[]{byte[].class}).withStandardTarget(ByteBuffer.class, new Class[0]).withStandardTarget(String.class, new Class[0])),
        BYTE_BUFFER(ScalarAttributeType.B, new ConverterMap<S>(new Class[]{ByteBuffer.class}).withStandardTarget(byte[].class, new Class[0]).withStandardTarget(String.class, byte[].class).withStandardTarget(UUID.class, new Class[0])),
        CALENDAR(ScalarAttributeType.S, new ConverterMap<S>(new Class[]{Calendar.class}).withStandardTarget(Date.class, new Class[0]).withStandardTarget(String.class, Date.class)),
        CHARACTER(ScalarAttributeType.S, new ConverterMap<S>(new Class[]{Character.class, Character.TYPE}).withStandardTarget(String.class, new Class[0])),
        CURRENCY(ScalarAttributeType.S, new ConverterMap<S>(new Class[]{Currency.class}).withStandardTarget(String.class, new Class[0])),
        DATE(ScalarAttributeType.S, new ConverterMap<S>(new Class[]{Date.class}).withStandardTarget(Calendar.class, new Class[0]).withStandardTarget(Long.class, new Class[0]).withStandardTarget(String.class, new Class[0])),
        DOUBLE(ScalarAttributeType.N, new ConverterMap<S>(new Class[]{Double.class, Double.TYPE}).withStandardTarget(Number.class, new Class[0]).withStandardTarget(String.class, new Class[0])),
        FLOAT(ScalarAttributeType.N, new ConverterMap<S>(new Class[]{Float.class, Float.TYPE}).withStandardTarget(Number.class, new Class[0]).withStandardTarget(String.class, new Class[0])),
        INTEGER(ScalarAttributeType.N, new ConverterMap<S>(new Class[]{Integer.class, Integer.TYPE}).withStandardTarget(Number.class, new Class[0]).withStandardTarget(String.class, new Class[0])),
        LOCALE(ScalarAttributeType.S, new ConverterMap<S>(new Class[]{Locale.class}).withStandardTarget(String.class, new Class[0])),
        LONG(ScalarAttributeType.N, new ConverterMap<S>(new Class[]{Long.class, Long.TYPE}).withStandardTarget(Date.class, new Class[0]).withStandardTarget(Number.class, new Class[0]).withStandardTarget(String.class, new Class[0])),
        S3_LINK(ScalarAttributeType.S, new ConverterMap<S>(new Class[]{S3Link.class})),
        SHORT(ScalarAttributeType.N, new ConverterMap<S>(new Class[]{Short.class, Short.TYPE}).withStandardTarget(Number.class, new Class[0]).withStandardTarget(String.class, new Class[0])),
        STRING(ScalarAttributeType.S, new ConverterMap<S>(new Class[]{String.class}).withStandardTarget(Boolean.class, new Class[0]).withStandardTarget(byte[].class, new Class[0]).withStandardTarget(ByteBuffer.class, byte[].class).withStandardTarget(Calendar.class, Date.class).withStandardTarget(Date.class, new Class[0]).withStandardTarget(Enum.class, new Class[0]).withStandardTarget(Locale.class, new Class[0]).withStandardTarget(TimeZone.class, new Class[0]).withStandardTarget(Object.class, new Class[0])),
        TIME_ZONE(ScalarAttributeType.S, new ConverterMap<S>(new Class[]{TimeZone.class}).withStandardTarget(String.class, new Class[0])),
        UUID(ScalarAttributeType.S, new ConverterMap<S>(new Class[]{UUID.class}).withStandardTarget(ByteBuffer.class, new Class[0]).withStandardTarget(String.class, new Class[0])),
        DEFAULT(null, new ConverterMap<S>(new Class[]{Object.class}));

        private final ScalarAttributeType scalarAttributeType;
        private final ConverterMap<?> map;

        private Scalar(ScalarAttributeType scalarAttributeType, ConverterMap<?> map) {
            this.scalarAttributeType = scalarAttributeType;
            this.map = map;
        }

        final <S, T> Converter<S, T> getConverter(final Class<S> sourceType, Class<T> targetType) {
            if (this == DEFAULT && sourceType.isEnum() && STRING.is(targetType)) {
                return new Converter<Enum, String>(){

                    @Override
                    public final Enum convert(String o) {
                        return Enum.valueOf(sourceType, o);
                    }
                };
            }
            return this.map.getConverter(sourceType, targetType);
        }

        final <S, T> S convert(T o) {
            return this.getConverter(this.type(), o.getClass()).convert(o);
        }

        final <S, T> DynamoDBTypeConverter<S, T> join(Class<T> targetType) {
            return Scalar.join(this.type(), targetType);
        }

        final boolean is(ScalarAttributeType scalarAttributeType) {
            return this.scalarAttributeType == scalarAttributeType;
        }

        final boolean is(Class<?> sourceType) {
            return this.map.isAssignableFrom(sourceType);
        }

        final <S> Class<S> type() {
            return ((ConverterMap)this.map).types[0];
        }

        static <S, T> DynamoDBTypeConverter<S, T> join(Class<S> sourceType, Class<T> targetType) {
            Scalar source = Scalar.of(sourceType);
            Scalar target = Scalar.of(targetType);
            final Converter<S, S> sourceFromTarget = source.getConverter(sourceType, target.type());
            final Converter<T, S> targetFromSource = target.getConverter(targetType, source.type());
            return new DynamoDBTypeConverter<S, T>(){

                @Override
                public final S convert(T o) {
                    return sourceFromTarget.convert(o);
                }

                @Override
                public final T unconvert(S o) {
                    return targetFromSource.convert(o);
                }
            };
        }

        static Scalar of(Class<?> sourceType) {
            for (Scalar scalar : Scalar.values()) {
                if (!scalar.is(sourceType)) continue;
                return scalar;
            }
            return DEFAULT;
        }
    }
}

