/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationautoscaling.model.DeregisterScalableTargetRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeregisterScalableTargetRequestMarshaller
implements Marshaller<Request<DeregisterScalableTargetRequest>, DeregisterScalableTargetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeregisterScalableTargetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeregisterScalableTargetRequest> marshall(DeregisterScalableTargetRequest deregisterScalableTargetRequest) {
        if (deregisterScalableTargetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeregisterScalableTargetRequest> request = new DefaultRequest<DeregisterScalableTargetRequest>(deregisterScalableTargetRequest, "AWSApplicationAutoScaling");
        request.addHeader("X-Amz-Target", "AnyScaleFrontendService.DeregisterScalableTarget");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deregisterScalableTargetRequest.getServiceNamespace() != null) {
                jsonGenerator.writeFieldName("ServiceNamespace").writeValue(deregisterScalableTargetRequest.getServiceNamespace());
            }
            if (deregisterScalableTargetRequest.getResourceId() != null) {
                jsonGenerator.writeFieldName("ResourceId").writeValue(deregisterScalableTargetRequest.getResourceId());
            }
            if (deregisterScalableTargetRequest.getScalableDimension() != null) {
                jsonGenerator.writeFieldName("ScalableDimension").writeValue(deregisterScalableTargetRequest.getScalableDimension());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

