/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.support.AWSSupport;
import com.amazonaws.services.support.AWSSupportClientBuilder;
import com.amazonaws.services.support.model.AWSSupportException;
import com.amazonaws.services.support.model.AddAttachmentsToSetRequest;
import com.amazonaws.services.support.model.AddAttachmentsToSetResult;
import com.amazonaws.services.support.model.AddCommunicationToCaseRequest;
import com.amazonaws.services.support.model.AddCommunicationToCaseResult;
import com.amazonaws.services.support.model.AttachmentIdNotFoundException;
import com.amazonaws.services.support.model.AttachmentLimitExceededException;
import com.amazonaws.services.support.model.AttachmentSetExpiredException;
import com.amazonaws.services.support.model.AttachmentSetIdNotFoundException;
import com.amazonaws.services.support.model.AttachmentSetSizeLimitExceededException;
import com.amazonaws.services.support.model.CaseCreationLimitExceededException;
import com.amazonaws.services.support.model.CaseIdNotFoundException;
import com.amazonaws.services.support.model.CreateCaseRequest;
import com.amazonaws.services.support.model.CreateCaseResult;
import com.amazonaws.services.support.model.DescribeAttachmentLimitExceededException;
import com.amazonaws.services.support.model.DescribeAttachmentRequest;
import com.amazonaws.services.support.model.DescribeAttachmentResult;
import com.amazonaws.services.support.model.DescribeCasesRequest;
import com.amazonaws.services.support.model.DescribeCasesResult;
import com.amazonaws.services.support.model.DescribeCommunicationsRequest;
import com.amazonaws.services.support.model.DescribeCommunicationsResult;
import com.amazonaws.services.support.model.DescribeServicesRequest;
import com.amazonaws.services.support.model.DescribeServicesResult;
import com.amazonaws.services.support.model.DescribeSeverityLevelsRequest;
import com.amazonaws.services.support.model.DescribeSeverityLevelsResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckResultRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckResultResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckSummariesResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorChecksRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorChecksResult;
import com.amazonaws.services.support.model.InternalServerErrorException;
import com.amazonaws.services.support.model.RefreshTrustedAdvisorCheckRequest;
import com.amazonaws.services.support.model.RefreshTrustedAdvisorCheckResult;
import com.amazonaws.services.support.model.ResolveCaseRequest;
import com.amazonaws.services.support.model.ResolveCaseResult;
import com.amazonaws.services.support.model.transform.AddAttachmentsToSetRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.AddAttachmentsToSetResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.AddCommunicationToCaseRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.AddCommunicationToCaseResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.CreateCaseRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.CreateCaseResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeAttachmentRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.DescribeAttachmentResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeCasesRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.DescribeCasesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeCommunicationsRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.DescribeCommunicationsResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeServicesRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.DescribeServicesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeSeverityLevelsRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.DescribeSeverityLevelsResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckRefreshStatusesRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckRefreshStatusesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckResultRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckResultResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckSummariesRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckSummariesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorChecksRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorChecksResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.RefreshTrustedAdvisorCheckRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.RefreshTrustedAdvisorCheckResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.ResolveCaseRequestProtocolMarshaller;
import com.amazonaws.services.support.model.transform.ResolveCaseResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSSupportClient
extends AmazonWebServiceClient
implements AWSSupport {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSupport.class);
    private static final String DEFAULT_SIGNING_NAME = "support";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AttachmentSetIdNotFound").withModeledClass(AttachmentSetIdNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CaseCreationLimitExceeded").withModeledClass(CaseCreationLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AttachmentIdNotFound").withModeledClass(AttachmentIdNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AttachmentSetExpired").withModeledClass(AttachmentSetExpiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AttachmentLimitExceeded").withModeledClass(AttachmentLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CaseIdNotFound").withModeledClass(CaseIdNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DescribeAttachmentLimitExceeded").withModeledClass(DescribeAttachmentLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AttachmentSetSizeLimitExceeded").withModeledClass(AttachmentSetSizeLimitExceededException.class)).withBaseServiceExceptionClass(AWSSupportException.class));

    @Deprecated
    public AWSSupportClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSSupportClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSSupportClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSSupportClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSSupportClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSSupportClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSSupportClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AWSSupportClientBuilder builder() {
        return AWSSupportClientBuilder.standard();
    }

    AWSSupportClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://support.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/support/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/support/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AddAttachmentsToSetResult addAttachmentsToSet(AddAttachmentsToSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAddAttachmentsToSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddAttachmentsToSetResult executeAddAttachmentsToSet(AddAttachmentsToSetRequest addAttachmentsToSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addAttachmentsToSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddAttachmentsToSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddAttachmentsToSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(addAttachmentsToSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AddAttachmentsToSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddAttachmentsToSetResult addAttachmentsToSetResult = (AddAttachmentsToSetResult)response.getAwsResponse();
            return addAttachmentsToSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AddCommunicationToCaseResult addCommunicationToCase(AddCommunicationToCaseRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAddCommunicationToCase(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddCommunicationToCaseResult executeAddCommunicationToCase(AddCommunicationToCaseRequest addCommunicationToCaseRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addCommunicationToCaseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddCommunicationToCaseRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddCommunicationToCaseRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(addCommunicationToCaseRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AddCommunicationToCaseResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddCommunicationToCaseResult addCommunicationToCaseResult = (AddCommunicationToCaseResult)response.getAwsResponse();
            return addCommunicationToCaseResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateCaseResult createCase(CreateCaseRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateCase(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateCaseResult executeCreateCase(CreateCaseRequest createCaseRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCaseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCaseRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCaseRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createCaseRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateCaseResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCaseResult createCaseResult = (CreateCaseResult)response.getAwsResponse();
            return createCaseResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAttachmentResult describeAttachment(DescribeAttachmentRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeAttachment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAttachmentResult executeDescribeAttachment(DescribeAttachmentRequest describeAttachmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAttachmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAttachmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAttachmentRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeAttachmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeAttachmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAttachmentResult describeAttachmentResult = (DescribeAttachmentResult)response.getAwsResponse();
            return describeAttachmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeCasesResult describeCases(DescribeCasesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeCases(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeCasesResult executeDescribeCases(DescribeCasesRequest describeCasesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCasesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCasesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCasesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeCasesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeCasesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeCasesResult describeCasesResult = (DescribeCasesResult)response.getAwsResponse();
            return describeCasesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeCasesResult describeCases() {
        return this.describeCases(new DescribeCasesRequest());
    }

    @Override
    public DescribeCommunicationsResult describeCommunications(DescribeCommunicationsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeCommunications(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeCommunicationsResult executeDescribeCommunications(DescribeCommunicationsRequest describeCommunicationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCommunicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCommunicationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCommunicationsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeCommunicationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeCommunicationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeCommunicationsResult describeCommunicationsResult = (DescribeCommunicationsResult)response.getAwsResponse();
            return describeCommunicationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeServicesResult describeServices(DescribeServicesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeServices(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeServicesResult executeDescribeServices(DescribeServicesRequest describeServicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeServicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeServicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeServicesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeServicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeServicesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeServicesResult describeServicesResult = (DescribeServicesResult)response.getAwsResponse();
            return describeServicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeServicesResult describeServices() {
        return this.describeServices(new DescribeServicesRequest());
    }

    @Override
    public DescribeSeverityLevelsResult describeSeverityLevels(DescribeSeverityLevelsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeSeverityLevels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSeverityLevelsResult executeDescribeSeverityLevels(DescribeSeverityLevelsRequest describeSeverityLevelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSeverityLevelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSeverityLevelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSeverityLevelsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeSeverityLevelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeSeverityLevelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSeverityLevelsResult describeSeverityLevelsResult = (DescribeSeverityLevelsResult)response.getAwsResponse();
            return describeSeverityLevelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSeverityLevelsResult describeSeverityLevels() {
        return this.describeSeverityLevels(new DescribeSeverityLevelsRequest());
    }

    @Override
    public DescribeTrustedAdvisorCheckRefreshStatusesResult describeTrustedAdvisorCheckRefreshStatuses(DescribeTrustedAdvisorCheckRefreshStatusesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeTrustedAdvisorCheckRefreshStatuses(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTrustedAdvisorCheckRefreshStatusesResult executeDescribeTrustedAdvisorCheckRefreshStatuses(DescribeTrustedAdvisorCheckRefreshStatusesRequest describeTrustedAdvisorCheckRefreshStatusesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTrustedAdvisorCheckRefreshStatusesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTrustedAdvisorCheckRefreshStatusesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTrustedAdvisorCheckRefreshStatusesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeTrustedAdvisorCheckRefreshStatusesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeTrustedAdvisorCheckRefreshStatusesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTrustedAdvisorCheckRefreshStatusesResult describeTrustedAdvisorCheckRefreshStatusesResult = (DescribeTrustedAdvisorCheckRefreshStatusesResult)response.getAwsResponse();
            return describeTrustedAdvisorCheckRefreshStatusesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTrustedAdvisorCheckResultResult describeTrustedAdvisorCheckResult(DescribeTrustedAdvisorCheckResultRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeTrustedAdvisorCheckResult(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTrustedAdvisorCheckResultResult executeDescribeTrustedAdvisorCheckResult(DescribeTrustedAdvisorCheckResultRequest describeTrustedAdvisorCheckResultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTrustedAdvisorCheckResultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTrustedAdvisorCheckResultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTrustedAdvisorCheckResultRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeTrustedAdvisorCheckResultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeTrustedAdvisorCheckResultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTrustedAdvisorCheckResultResult describeTrustedAdvisorCheckResultResult = (DescribeTrustedAdvisorCheckResultResult)response.getAwsResponse();
            return describeTrustedAdvisorCheckResultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTrustedAdvisorCheckSummariesResult describeTrustedAdvisorCheckSummaries(DescribeTrustedAdvisorCheckSummariesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeTrustedAdvisorCheckSummaries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTrustedAdvisorCheckSummariesResult executeDescribeTrustedAdvisorCheckSummaries(DescribeTrustedAdvisorCheckSummariesRequest describeTrustedAdvisorCheckSummariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTrustedAdvisorCheckSummariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTrustedAdvisorCheckSummariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTrustedAdvisorCheckSummariesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeTrustedAdvisorCheckSummariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeTrustedAdvisorCheckSummariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTrustedAdvisorCheckSummariesResult describeTrustedAdvisorCheckSummariesResult = (DescribeTrustedAdvisorCheckSummariesResult)response.getAwsResponse();
            return describeTrustedAdvisorCheckSummariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTrustedAdvisorChecksResult describeTrustedAdvisorChecks(DescribeTrustedAdvisorChecksRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeTrustedAdvisorChecks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTrustedAdvisorChecksResult executeDescribeTrustedAdvisorChecks(DescribeTrustedAdvisorChecksRequest describeTrustedAdvisorChecksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTrustedAdvisorChecksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTrustedAdvisorChecksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTrustedAdvisorChecksRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeTrustedAdvisorChecksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeTrustedAdvisorChecksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTrustedAdvisorChecksResult describeTrustedAdvisorChecksResult = (DescribeTrustedAdvisorChecksResult)response.getAwsResponse();
            return describeTrustedAdvisorChecksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RefreshTrustedAdvisorCheckResult refreshTrustedAdvisorCheck(RefreshTrustedAdvisorCheckRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRefreshTrustedAdvisorCheck(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RefreshTrustedAdvisorCheckResult executeRefreshTrustedAdvisorCheck(RefreshTrustedAdvisorCheckRequest refreshTrustedAdvisorCheckRequest) {
        ExecutionContext executionContext = this.createExecutionContext(refreshTrustedAdvisorCheckRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RefreshTrustedAdvisorCheckRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RefreshTrustedAdvisorCheckRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(refreshTrustedAdvisorCheckRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RefreshTrustedAdvisorCheckResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RefreshTrustedAdvisorCheckResult refreshTrustedAdvisorCheckResult = (RefreshTrustedAdvisorCheckResult)response.getAwsResponse();
            return refreshTrustedAdvisorCheckResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResolveCaseResult resolveCase(ResolveCaseRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeResolveCase(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ResolveCaseResult executeResolveCase(ResolveCaseRequest resolveCaseRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resolveCaseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ResolveCaseRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ResolveCaseRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(resolveCaseRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ResolveCaseResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ResolveCaseResult resolveCaseResult = (ResolveCaseResult)response.getAwsResponse();
            return resolveCaseResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResolveCaseResult resolveCase() {
        return this.resolveCase(new ResolveCaseRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

