/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.serverlessapplicationrepository.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.ApplicationPolicyStatement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutApplicationPolicyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationId;
    private List<ApplicationPolicyStatement> statements;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public PutApplicationPolicyRequest withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public List<ApplicationPolicyStatement> getStatements() {
        return this.statements;
    }

    public void setStatements(Collection<ApplicationPolicyStatement> statements) {
        if (statements == null) {
            this.statements = null;
            return;
        }
        this.statements = new ArrayList<ApplicationPolicyStatement>(statements);
    }

    public PutApplicationPolicyRequest withStatements(ApplicationPolicyStatement ... statements) {
        if (this.statements == null) {
            this.setStatements(new ArrayList<ApplicationPolicyStatement>(statements.length));
        }
        for (ApplicationPolicyStatement ele : statements) {
            this.statements.add(ele);
        }
        return this;
    }

    public PutApplicationPolicyRequest withStatements(Collection<ApplicationPolicyStatement> statements) {
        this.setStatements(statements);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getStatements() != null) {
            sb.append("Statements: ").append(this.getStatements());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApplicationPolicyRequest)) {
            return false;
        }
        PutApplicationPolicyRequest other = (PutApplicationPolicyRequest)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getStatements() == null ^ this.getStatements() == null) {
            return false;
        }
        return other.getStatements() == null || other.getStatements().equals(this.getStatements());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getStatements() == null ? 0 : this.getStatements().hashCode());
        return hashCode;
    }

    @Override
    public PutApplicationPolicyRequest clone() {
        return (PutApplicationPolicyRequest)super.clone();
    }
}

