/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.route53domains.AmazonRoute53DomainsClientBuilder;
import com.amazonaws.services.route53domains.model.AmazonRoute53DomainsException;
import com.amazonaws.services.route53domains.model.CheckDomainAvailabilityRequest;
import com.amazonaws.services.route53domains.model.CheckDomainAvailabilityResult;
import com.amazonaws.services.route53domains.model.CheckDomainTransferabilityRequest;
import com.amazonaws.services.route53domains.model.CheckDomainTransferabilityResult;
import com.amazonaws.services.route53domains.model.DeleteTagsForDomainRequest;
import com.amazonaws.services.route53domains.model.DeleteTagsForDomainResult;
import com.amazonaws.services.route53domains.model.DisableDomainAutoRenewRequest;
import com.amazonaws.services.route53domains.model.DisableDomainAutoRenewResult;
import com.amazonaws.services.route53domains.model.DisableDomainTransferLockRequest;
import com.amazonaws.services.route53domains.model.DisableDomainTransferLockResult;
import com.amazonaws.services.route53domains.model.DomainLimitExceededException;
import com.amazonaws.services.route53domains.model.DuplicateRequestException;
import com.amazonaws.services.route53domains.model.EnableDomainAutoRenewRequest;
import com.amazonaws.services.route53domains.model.EnableDomainAutoRenewResult;
import com.amazonaws.services.route53domains.model.EnableDomainTransferLockRequest;
import com.amazonaws.services.route53domains.model.EnableDomainTransferLockResult;
import com.amazonaws.services.route53domains.model.GetContactReachabilityStatusRequest;
import com.amazonaws.services.route53domains.model.GetContactReachabilityStatusResult;
import com.amazonaws.services.route53domains.model.GetDomainDetailRequest;
import com.amazonaws.services.route53domains.model.GetDomainDetailResult;
import com.amazonaws.services.route53domains.model.GetDomainSuggestionsRequest;
import com.amazonaws.services.route53domains.model.GetDomainSuggestionsResult;
import com.amazonaws.services.route53domains.model.GetOperationDetailRequest;
import com.amazonaws.services.route53domains.model.GetOperationDetailResult;
import com.amazonaws.services.route53domains.model.InvalidInputException;
import com.amazonaws.services.route53domains.model.ListDomainsRequest;
import com.amazonaws.services.route53domains.model.ListDomainsResult;
import com.amazonaws.services.route53domains.model.ListOperationsRequest;
import com.amazonaws.services.route53domains.model.ListOperationsResult;
import com.amazonaws.services.route53domains.model.ListTagsForDomainRequest;
import com.amazonaws.services.route53domains.model.ListTagsForDomainResult;
import com.amazonaws.services.route53domains.model.OperationLimitExceededException;
import com.amazonaws.services.route53domains.model.RegisterDomainRequest;
import com.amazonaws.services.route53domains.model.RegisterDomainResult;
import com.amazonaws.services.route53domains.model.RenewDomainRequest;
import com.amazonaws.services.route53domains.model.RenewDomainResult;
import com.amazonaws.services.route53domains.model.ResendContactReachabilityEmailRequest;
import com.amazonaws.services.route53domains.model.ResendContactReachabilityEmailResult;
import com.amazonaws.services.route53domains.model.RetrieveDomainAuthCodeRequest;
import com.amazonaws.services.route53domains.model.RetrieveDomainAuthCodeResult;
import com.amazonaws.services.route53domains.model.TLDRulesViolationException;
import com.amazonaws.services.route53domains.model.TransferDomainRequest;
import com.amazonaws.services.route53domains.model.TransferDomainResult;
import com.amazonaws.services.route53domains.model.UnsupportedTLDException;
import com.amazonaws.services.route53domains.model.UpdateDomainContactPrivacyRequest;
import com.amazonaws.services.route53domains.model.UpdateDomainContactPrivacyResult;
import com.amazonaws.services.route53domains.model.UpdateDomainContactRequest;
import com.amazonaws.services.route53domains.model.UpdateDomainContactResult;
import com.amazonaws.services.route53domains.model.UpdateDomainNameserversRequest;
import com.amazonaws.services.route53domains.model.UpdateDomainNameserversResult;
import com.amazonaws.services.route53domains.model.UpdateTagsForDomainRequest;
import com.amazonaws.services.route53domains.model.UpdateTagsForDomainResult;
import com.amazonaws.services.route53domains.model.ViewBillingRequest;
import com.amazonaws.services.route53domains.model.ViewBillingResult;
import com.amazonaws.services.route53domains.model.transform.CheckDomainAvailabilityRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.CheckDomainAvailabilityResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.CheckDomainTransferabilityRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.CheckDomainTransferabilityResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.DeleteTagsForDomainRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.DeleteTagsForDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainAutoRenewRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainAutoRenewResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainTransferLockRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainTransferLockResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainAutoRenewRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainAutoRenewResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainTransferLockRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainTransferLockResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.GetContactReachabilityStatusRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.GetContactReachabilityStatusResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.GetDomainDetailRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.GetDomainDetailResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.GetDomainSuggestionsRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.GetDomainSuggestionsResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.GetOperationDetailRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.GetOperationDetailResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ListDomainsRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.ListDomainsResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ListOperationsRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.ListOperationsResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ListTagsForDomainRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.ListTagsForDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.RegisterDomainRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.RegisterDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.RenewDomainRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.RenewDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ResendContactReachabilityEmailRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.ResendContactReachabilityEmailResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.RetrieveDomainAuthCodeRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.RetrieveDomainAuthCodeResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.TransferDomainRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.TransferDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactPrivacyRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactPrivacyResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainNameserversRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainNameserversResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateTagsForDomainRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateTagsForDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ViewBillingRequestProtocolMarshaller;
import com.amazonaws.services.route53domains.model.transform.ViewBillingResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonRoute53DomainsClient
extends AmazonWebServiceClient
implements AmazonRoute53Domains {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonRoute53Domains.class);
    private static final String DEFAULT_SIGNING_NAME = "route53domains";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRequest").withModeledClass(DuplicateRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInput").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TLDRulesViolation").withModeledClass(TLDRulesViolationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DomainLimitExceeded").withModeledClass(DomainLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedTLD").withModeledClass(UnsupportedTLDException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationLimitExceeded").withModeledClass(OperationLimitExceededException.class)).withBaseServiceExceptionClass(AmazonRoute53DomainsException.class));

    @Deprecated
    public AmazonRoute53DomainsClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonRoute53DomainsClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonRoute53DomainsClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonRoute53DomainsClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonRoute53DomainsClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonRoute53DomainsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonRoute53DomainsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonRoute53DomainsClientBuilder builder() {
        return AmazonRoute53DomainsClientBuilder.standard();
    }

    AmazonRoute53DomainsClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://route53domains.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/route53domains/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/route53domains/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CheckDomainAvailabilityResult checkDomainAvailability(CheckDomainAvailabilityRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCheckDomainAvailability(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CheckDomainAvailabilityResult executeCheckDomainAvailability(CheckDomainAvailabilityRequest checkDomainAvailabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(checkDomainAvailabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CheckDomainAvailabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CheckDomainAvailabilityRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(checkDomainAvailabilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CheckDomainAvailabilityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CheckDomainAvailabilityResult checkDomainAvailabilityResult = (CheckDomainAvailabilityResult)response.getAwsResponse();
            return checkDomainAvailabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CheckDomainTransferabilityResult checkDomainTransferability(CheckDomainTransferabilityRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCheckDomainTransferability(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CheckDomainTransferabilityResult executeCheckDomainTransferability(CheckDomainTransferabilityRequest checkDomainTransferabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(checkDomainTransferabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CheckDomainTransferabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CheckDomainTransferabilityRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(checkDomainTransferabilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CheckDomainTransferabilityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CheckDomainTransferabilityResult checkDomainTransferabilityResult = (CheckDomainTransferabilityResult)response.getAwsResponse();
            return checkDomainTransferabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTagsForDomainResult deleteTagsForDomain(DeleteTagsForDomainRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteTagsForDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTagsForDomainResult executeDeleteTagsForDomain(DeleteTagsForDomainRequest deleteTagsForDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTagsForDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTagsForDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTagsForDomainRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteTagsForDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteTagsForDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTagsForDomainResult deleteTagsForDomainResult = (DeleteTagsForDomainResult)response.getAwsResponse();
            return deleteTagsForDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisableDomainAutoRenewResult disableDomainAutoRenew(DisableDomainAutoRenewRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisableDomainAutoRenew(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableDomainAutoRenewResult executeDisableDomainAutoRenew(DisableDomainAutoRenewRequest disableDomainAutoRenewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableDomainAutoRenewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableDomainAutoRenewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableDomainAutoRenewRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disableDomainAutoRenewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisableDomainAutoRenewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableDomainAutoRenewResult disableDomainAutoRenewResult = (DisableDomainAutoRenewResult)response.getAwsResponse();
            return disableDomainAutoRenewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisableDomainTransferLockResult disableDomainTransferLock(DisableDomainTransferLockRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisableDomainTransferLock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableDomainTransferLockResult executeDisableDomainTransferLock(DisableDomainTransferLockRequest disableDomainTransferLockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableDomainTransferLockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableDomainTransferLockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableDomainTransferLockRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disableDomainTransferLockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisableDomainTransferLockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableDomainTransferLockResult disableDomainTransferLockResult = (DisableDomainTransferLockResult)response.getAwsResponse();
            return disableDomainTransferLockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableDomainAutoRenewResult enableDomainAutoRenew(EnableDomainAutoRenewRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeEnableDomainAutoRenew(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableDomainAutoRenewResult executeEnableDomainAutoRenew(EnableDomainAutoRenewRequest enableDomainAutoRenewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableDomainAutoRenewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableDomainAutoRenewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableDomainAutoRenewRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(enableDomainAutoRenewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new EnableDomainAutoRenewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableDomainAutoRenewResult enableDomainAutoRenewResult = (EnableDomainAutoRenewResult)response.getAwsResponse();
            return enableDomainAutoRenewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableDomainTransferLockResult enableDomainTransferLock(EnableDomainTransferLockRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeEnableDomainTransferLock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableDomainTransferLockResult executeEnableDomainTransferLock(EnableDomainTransferLockRequest enableDomainTransferLockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableDomainTransferLockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableDomainTransferLockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableDomainTransferLockRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(enableDomainTransferLockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new EnableDomainTransferLockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableDomainTransferLockResult enableDomainTransferLockResult = (EnableDomainTransferLockResult)response.getAwsResponse();
            return enableDomainTransferLockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetContactReachabilityStatusResult getContactReachabilityStatus(GetContactReachabilityStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetContactReachabilityStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetContactReachabilityStatusResult executeGetContactReachabilityStatus(GetContactReachabilityStatusRequest getContactReachabilityStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getContactReachabilityStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetContactReachabilityStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetContactReachabilityStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getContactReachabilityStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetContactReachabilityStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetContactReachabilityStatusResult getContactReachabilityStatusResult = (GetContactReachabilityStatusResult)response.getAwsResponse();
            return getContactReachabilityStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDomainDetailResult getDomainDetail(GetDomainDetailRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetDomainDetail(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDomainDetailResult executeGetDomainDetail(GetDomainDetailRequest getDomainDetailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDomainDetailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDomainDetailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDomainDetailRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getDomainDetailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetDomainDetailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDomainDetailResult getDomainDetailResult = (GetDomainDetailResult)response.getAwsResponse();
            return getDomainDetailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDomainSuggestionsResult getDomainSuggestions(GetDomainSuggestionsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetDomainSuggestions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDomainSuggestionsResult executeGetDomainSuggestions(GetDomainSuggestionsRequest getDomainSuggestionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDomainSuggestionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDomainSuggestionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDomainSuggestionsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getDomainSuggestionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetDomainSuggestionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDomainSuggestionsResult getDomainSuggestionsResult = (GetDomainSuggestionsResult)response.getAwsResponse();
            return getDomainSuggestionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOperationDetailResult getOperationDetail(GetOperationDetailRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetOperationDetail(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOperationDetailResult executeGetOperationDetail(GetOperationDetailRequest getOperationDetailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOperationDetailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOperationDetailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOperationDetailRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getOperationDetailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetOperationDetailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOperationDetailResult getOperationDetailResult = (GetOperationDetailResult)response.getAwsResponse();
            return getOperationDetailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainsResult listDomains(ListDomainsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListDomains(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDomainsResult executeListDomains(ListDomainsRequest listDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDomainsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDomainsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listDomainsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListDomainsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDomainsResult listDomainsResult = (ListDomainsResult)response.getAwsResponse();
            return listDomainsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainsResult listDomains() {
        return this.listDomains(new ListDomainsRequest());
    }

    @Override
    public ListOperationsResult listOperations(ListOperationsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListOperations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOperationsResult executeListOperations(ListOperationsRequest listOperationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOperationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOperationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOperationsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listOperationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListOperationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOperationsResult listOperationsResult = (ListOperationsResult)response.getAwsResponse();
            return listOperationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOperationsResult listOperations() {
        return this.listOperations(new ListOperationsRequest());
    }

    @Override
    public ListTagsForDomainResult listTagsForDomain(ListTagsForDomainRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForDomainResult executeListTagsForDomain(ListTagsForDomainRequest listTagsForDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForDomainRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForDomainResult listTagsForDomainResult = (ListTagsForDomainResult)response.getAwsResponse();
            return listTagsForDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterDomainResult registerDomain(RegisterDomainRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRegisterDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterDomainResult executeRegisterDomain(RegisterDomainRequest registerDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterDomainRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(registerDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RegisterDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterDomainResult registerDomainResult = (RegisterDomainResult)response.getAwsResponse();
            return registerDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RenewDomainResult renewDomain(RenewDomainRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRenewDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RenewDomainResult executeRenewDomain(RenewDomainRequest renewDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(renewDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RenewDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RenewDomainRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(renewDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RenewDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RenewDomainResult renewDomainResult = (RenewDomainResult)response.getAwsResponse();
            return renewDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResendContactReachabilityEmailResult resendContactReachabilityEmail(ResendContactReachabilityEmailRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeResendContactReachabilityEmail(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ResendContactReachabilityEmailResult executeResendContactReachabilityEmail(ResendContactReachabilityEmailRequest resendContactReachabilityEmailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resendContactReachabilityEmailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ResendContactReachabilityEmailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ResendContactReachabilityEmailRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(resendContactReachabilityEmailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ResendContactReachabilityEmailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ResendContactReachabilityEmailResult resendContactReachabilityEmailResult = (ResendContactReachabilityEmailResult)response.getAwsResponse();
            return resendContactReachabilityEmailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RetrieveDomainAuthCodeResult retrieveDomainAuthCode(RetrieveDomainAuthCodeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRetrieveDomainAuthCode(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RetrieveDomainAuthCodeResult executeRetrieveDomainAuthCode(RetrieveDomainAuthCodeRequest retrieveDomainAuthCodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(retrieveDomainAuthCodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RetrieveDomainAuthCodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RetrieveDomainAuthCodeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(retrieveDomainAuthCodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RetrieveDomainAuthCodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RetrieveDomainAuthCodeResult retrieveDomainAuthCodeResult = (RetrieveDomainAuthCodeResult)response.getAwsResponse();
            return retrieveDomainAuthCodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TransferDomainResult transferDomain(TransferDomainRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTransferDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TransferDomainResult executeTransferDomain(TransferDomainRequest transferDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(transferDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TransferDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TransferDomainRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(transferDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TransferDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TransferDomainResult transferDomainResult = (TransferDomainResult)response.getAwsResponse();
            return transferDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDomainContactResult updateDomainContact(UpdateDomainContactRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateDomainContact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDomainContactResult executeUpdateDomainContact(UpdateDomainContactRequest updateDomainContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDomainContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDomainContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDomainContactRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateDomainContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateDomainContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDomainContactResult updateDomainContactResult = (UpdateDomainContactResult)response.getAwsResponse();
            return updateDomainContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDomainContactPrivacyResult updateDomainContactPrivacy(UpdateDomainContactPrivacyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateDomainContactPrivacy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDomainContactPrivacyResult executeUpdateDomainContactPrivacy(UpdateDomainContactPrivacyRequest updateDomainContactPrivacyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDomainContactPrivacyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDomainContactPrivacyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDomainContactPrivacyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateDomainContactPrivacyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateDomainContactPrivacyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDomainContactPrivacyResult updateDomainContactPrivacyResult = (UpdateDomainContactPrivacyResult)response.getAwsResponse();
            return updateDomainContactPrivacyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDomainNameserversResult updateDomainNameservers(UpdateDomainNameserversRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateDomainNameservers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDomainNameserversResult executeUpdateDomainNameservers(UpdateDomainNameserversRequest updateDomainNameserversRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDomainNameserversRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDomainNameserversRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDomainNameserversRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateDomainNameserversRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateDomainNameserversResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDomainNameserversResult updateDomainNameserversResult = (UpdateDomainNameserversResult)response.getAwsResponse();
            return updateDomainNameserversResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateTagsForDomainResult updateTagsForDomain(UpdateTagsForDomainRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateTagsForDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateTagsForDomainResult executeUpdateTagsForDomain(UpdateTagsForDomainRequest updateTagsForDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTagsForDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTagsForDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTagsForDomainRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateTagsForDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateTagsForDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateTagsForDomainResult updateTagsForDomainResult = (UpdateTagsForDomainResult)response.getAwsResponse();
            return updateTagsForDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ViewBillingResult viewBilling(ViewBillingRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeViewBilling(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ViewBillingResult executeViewBilling(ViewBillingRequest viewBillingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(viewBillingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ViewBillingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ViewBillingRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(viewBillingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ViewBillingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ViewBillingResult viewBillingResult = (ViewBillingResult)response.getAwsResponse();
            return viewBillingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

