/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.ColorCorrector;

@SdkInternalApi
public class ColorCorrectorMarshaller {
    private static final MarshallingInfo<Integer> BRIGHTNESS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brightness").build();
    private static final MarshallingInfo<String> COLORSPACECONVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorSpaceConversion").build();
    private static final MarshallingInfo<Integer> CONTRAST_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contrast").build();
    private static final MarshallingInfo<StructuredPojo> HDR10METADATA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hdr10Metadata").build();
    private static final MarshallingInfo<Integer> HUE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hue").build();
    private static final MarshallingInfo<Integer> SATURATION_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("saturation").build();
    private static final ColorCorrectorMarshaller instance = new ColorCorrectorMarshaller();

    public static ColorCorrectorMarshaller getInstance() {
        return instance;
    }

    public void marshall(ColorCorrector colorCorrector, ProtocolMarshaller protocolMarshaller) {
        if (colorCorrector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(colorCorrector.getBrightness(), BRIGHTNESS_BINDING);
            protocolMarshaller.marshall(colorCorrector.getColorSpaceConversion(), COLORSPACECONVERSION_BINDING);
            protocolMarshaller.marshall(colorCorrector.getContrast(), CONTRAST_BINDING);
            protocolMarshaller.marshall(colorCorrector.getHdr10Metadata(), HDR10METADATA_BINDING);
            protocolMarshaller.marshall(colorCorrector.getHue(), HUE_BINDING);
            protocolMarshaller.marshall(colorCorrector.getSaturation(), SATURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

