/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.services.lightsail.model.DiskMap;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class DiskMapJsonUnmarshaller
implements Unmarshaller<DiskMap, JsonUnmarshallerContext> {
    private static DiskMapJsonUnmarshaller instance;

    @Override
    public DiskMap unmarshall(JsonUnmarshallerContext context) throws Exception {
        DiskMap diskMap = new DiskMap();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("originalDiskPath", targetDepth)) {
                    context.nextToken();
                    diskMap.setOriginalDiskPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("newDiskName", targetDepth)) {
                    context.nextToken();
                    diskMap.setNewDiskName(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return diskMap;
    }

    public static DiskMapJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DiskMapJsonUnmarshaller();
        }
        return instance;
    }
}

